/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service;

import com.els.base.file.service.IFileManager;
import com.els.base.file.service.impl.AwsFileManager;
import com.els.base.file.service.impl.LocalFileManager;
import com.els.base.file.service.impl.OssFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FileManagerFactory {
    private static Map<Integer, IFileManager> fileManagerMap = new HashMap<Integer, IFileManager>();

    public static IFileManager getFileManager() {
        Properties properties = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        String saveType = properties.getProperty("resource.save.type", "local");
        switch (saveType.toLowerCase()) {
            case "local": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.LOCAL.getSaveType());
            }
            case "aws": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.AWS.getSaveType());
            }
            case "oss": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.OSS.getSaveType());
            }
        }
        return FileManagerFactory.getFileManager(FileSaveTypeEnum.LOCAL.getSaveType());
    }

    public static IFileManager getFileManager(int saveType) {
        return fileManagerMap.get(saveType);
    }

    static {
        LocalFileManager localFileManager = new LocalFileManager();
        localFileManager.init();
        AwsFileManager awsFileManager = new AwsFileManager();
        awsFileManager.init();
        OssFileManager oosFileManager = new OssFileManager();
        oosFileManager.init();
        fileManagerMap.put(FileSaveTypeEnum.LOCAL.getSaveType(), (IFileManager)localFileManager);
        fileManagerMap.put(FileSaveTypeEnum.AWS.getSaveType(), (IFileManager)awsFileManager);
        fileManagerMap.put(FileSaveTypeEnum.OSS.getSaveType(), (IFileManager)oosFileManager);
    }
}

