package com.els.base.file.service;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.els.base.file.entity.FileData;
import com.els.base.file.entity.FileDataExample;

@Component
public class DeleteExpiredFileJob {
	
	@Resource
	FileDataService fileDataService;
	
	public void deletedFile() throws Exception {
		FileDataExample example = new FileDataExample();
		FileDataExample.Criteria criteria = example.createCriteria();
		criteria.andExpiryDayIsNotNull().andExpiryDayLessThanOrEqualTo(new Date());
		List<FileData> list = this.fileDataService.queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(list)) {
			return ;
		}
		
		for (FileData fileData : list) {
			FileManagerFactory.getFileManager().remove(fileData);
		}
	}

}
