package com.els.base.file.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import com.els.base.file.service.impl.AwsFileManager;
import com.els.base.file.service.impl.LocalFileManager;
import com.els.base.file.service.impl.OssFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;

/**
 * 文件管理器工厂
 * @author hzy
 *
 */
public class FileManagerFactory {
	
	private static Map<Integer, IFileManager> fileManagerMap =new HashMap<>();
	
//	private final static FileManagerFactory fileManagerFactory = new FileManagerFactory();
			
	static{
		IFileManager localFileManager = new LocalFileManager();
		localFileManager.init();
		IFileManager awsFileManager = new AwsFileManager();
		awsFileManager.init();
		IFileManager oosFileManager = new OssFileManager();
		oosFileManager.init();
		
		fileManagerMap.put(FileSaveTypeEnum.LOCAL.getSaveType(), localFileManager);
		fileManagerMap.put(FileSaveTypeEnum.AWS.getSaveType(), awsFileManager);
		fileManagerMap.put(FileSaveTypeEnum.OSS.getSaveType(), oosFileManager);
	}
	
	/**
	 * 读取配置文件，生成相对应的文件管理器
	 * @return
	 */
	public static IFileManager getFileManager(){
		Properties properties = SpringContextHolder.getBean("sysConfig");
		String saveType = properties.getProperty("resource.save.type", "local"); //默认使用local
		switch (saveType.toLowerCase()) {
		case "local":
			return getFileManager(FileSaveTypeEnum.LOCAL.getSaveType());
		case "aws":
			return getFileManager(FileSaveTypeEnum.AWS.getSaveType());
		case "oss":
			return getFileManager(FileSaveTypeEnum.OSS.getSaveType());
		default:
			return getFileManager(FileSaveTypeEnum.LOCAL.getSaveType());
		}
	}

	public static IFileManager getFileManager(int saveType) {
		return fileManagerMap.get(saveType);
	}
	
}
