package com.els.base.file.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.springframework.web.multipart.MultipartFile;

import com.els.base.file.entity.FileData;

/**
 * 文件管理器
 * @author hzy
 *
 */
public interface IFileManager {
	
	/**
	 * 初始化功能
	 */
	public void init();
	
	/**
	 * 保存文件
	 * @param file
	 * @return
	 * @throws IOException 
	 */
	public FileData write(InputStream in, FileData fileData) throws IOException;
	
	/**
	 * 保存文件
	 * @param file
	 * @return
	 * @throws IOException 
	 */
	public FileData write(File file, FileData fileData) throws IOException;

	/**
	 * 保存文件
	 * @param file
	 * @return
	 * @throws IOException 
	 */
	public FileData write(MultipartFile file, FileData fileData) throws IOException;
	
	/**
	 * 读取文件
	 * @param fileData
	 * @return
	 * @throws IOException 
	 */
	public InputStream read(FileData fileData) throws IOException;
	
	/**
	 * 删除文件
	 * @param fileData
	 * @throws IOException 
	 */
	public void remove(FileData fileData) throws IOException;
	
	/**
	 * 是否存在
	 * @param fileData
	 * @return
	 */
	public boolean isExist(FileData fileData);
	
	/**
	 * 根据文件信息创建文件流
	 * @throws IOException 
	 */
	public OutputStream createOutputStream(FileData fileData) throws IOException;
	
	/**
	 * 根据文件信息创建空文件
	 * @param fileData
	 * @return
	 */
	public File createEmptyFile(FileData fileData);

}
