package com.els.base.file.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Properties;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.IFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;


public class AwsFileManager implements IFileManager {
	
	private static Logger logger = LoggerFactory.getLogger(AwsFileManager.class);
	
	private static String bucketName;// 服务器上存放文件的位置
    private static String keyName;  // 上传对象的唯一标识,这里用上文对象的名称来做唯一标识

//    private static String workspace = "C:\\Users\\xuguang001\\Desktop\\";// 本地上传的时候读取文件和输出文件的路径

    private static AmazonS3 s3client;
    private static SecretKey secretKey;
    private static SSECustomerKey sseKey;  //文件加密上传密钥
    private static String accessKey;  //访问密钥
    private static String secretAccessKey;  //私有密钥

    
	private static FileDataService fileDataService = SpringContextHolder.getOneBean(FileDataService.class);


	@Override
	public FileData write(InputStream in, FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public FileData write(File file, FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public FileData write(MultipartFile multfile, FileData fileData) throws IOException {
        //s3client = new AmazonS3Client(new ProfileCredentialsProvider());

		String isEncrypt = fileData.getIsEncrypt();
		if(Integer.parseInt(isEncrypt)==Constant.YES_INT){
			//创建加密key
	        secretKey = generateSecretKey();
	        //构造一个新客户提供服务器端使用SecretKey指定加密密钥
	        sseKey = new SSECustomerKey(secretKey);
			fileData.setEncryptKey(sseKey.getKey());
		}else{
			sseKey = null;
		}

        fileData.setId(UUIDGenerator.generateUUID());
		fileData.setFileName(multfile.getOriginalFilename());
		fileData.setFileSize(Long.valueOf(multfile.getSize()).intValue());
		fileData.setSaveType(FileSaveTypeEnum.AWS.getSaveType());
				
        //上传文件服务端加密
		PutObjectResult objectResult = serverSideEncryptionPutObject(multfile);
		
		if(objectResult != null){//上传到AWS-S3平台成功
			// 文件信息保存到表里
	     	fileDataService.addObj(fileData);
		}

		return fileData;
	}

	@Override
	public S3ObjectInputStream read(FileData fileData) {
		String isEncrypt = fileData.getIsEncrypt();
		keyName = fileData.getFileName();
		if(Integer.parseInt(isEncrypt)==Constant.YES_INT){
			String encryptKey = fileData.getEncryptKey();
	        //构造一个新客户提供服务器端使用SecretKey指定加密密钥
	        sseKey = new SSECustomerKey(encryptKey);
		}else{
			sseKey = null;
		}
        // 下载文件
        return downloadObject(sseKey);
	}
	@Transactional
	@Override
	public void remove(FileData fileData) {
		String fileId = fileData.getId();
		fileDataService.deleteObjById(fileId);
		keyName = fileData.getFileName();
		DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, keyName);
		s3client.deleteObject(deleteObjectRequest);
	}

	@Override
	public boolean isExist(FileData fileData) {
		logger.info("此方法暂时未开发！");
		return true;
	}

	@Override
	public void init() {
		Properties sysConfig = SpringContextHolder.getBean("sysConfig");
		
		bucketName = sysConfig.getProperty("aws.bucketName");
		accessKey = sysConfig.getProperty("aws.accessKey");
		secretAccessKey = sysConfig.getProperty("aws.secretKey");
		
		if(StringUtils.isBlank(accessKey) 
				|| StringUtils.isBlank(secretAccessKey)
				|| StringUtils.isBlank(bucketName)){
			logger.warn("亚马逊S3云服务启用失败,缺乏配置。 aws.bucketName[{0}],aws.accessKey[{1}],aws.secretKey[{2}]", new String[]{bucketName, accessKey, secretAccessKey});
			return;
		}
		
		//允许调用者传入AWS访问密钥和秘密访问在构造函数中。
		BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretAccessKey);
		//构建使用的客户端
		s3client = AmazonS3ClientBuilder.standard().withRegion(Regions.CN_NORTH_1).withCredentials(new AWSStaticCredentialsProvider(awsCreds)).build();

	}
	
	/**
     * 服务端加密上传
	 * @throws IOException 
     */
    private PutObjectResult serverSideEncryptionPutObject(MultipartFile multfile) throws IOException {
    	//String uploadFileName = "ceshi.txt";
        //keyName = Paths.get(workspace + uploadFileName).getFileName().toString();
    	// 文件名称
    	keyName = multfile.getOriginalFilename();
    	PutObjectResult result = uploadObject(multfile.getInputStream(), sseKey);
        return result;
    }
    
    private PutObjectResult uploadObject(InputStream file, SSECustomerKey sseKey) {
        // 1. Upload Object.
        PutObjectRequest putObjectRequest = null;
		ObjectMetadata metadata = new ObjectMetadata();

		// sseKey是否加密
        if(sseKey == null){
            putObjectRequest = new PutObjectRequest(bucketName, keyName, file, metadata);
        }else{
            putObjectRequest = new PutObjectRequest(bucketName, keyName, file, metadata).withSSECustomerKey(sseKey);
        }

        PutObjectResult result = s3client.putObject(putObjectRequest);
        return result;
    }
    
    /**
     * 创建AES-256密钥
     * @return SecretKey Object
     */
    private static SecretKey generateSecretKey() {
        try {
            SecretKey key = null;
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256, new SecureRandom());
            key = generator.generateKey();
            return key;
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
    
    private S3ObjectInputStream downloadObject(SSECustomerKey sseKey) {
        GetObjectRequest getObjectRequest = null;

        if(sseKey == null){
            getObjectRequest = new GetObjectRequest(bucketName, keyName);
        }else{
            getObjectRequest = new GetObjectRequest(bucketName, keyName).withSSECustomerKey(sseKey);
        }

        S3Object s3Object = s3client.getObject(getObjectRequest);

        return s3Object.getObjectContent();
    }

	@Override
	public OutputStream createOutputStream(FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public File createEmptyFile(FileData fileData) {
		logger.info("此方法暂时未开发！");
		return null;
	}

	
}
