package com.els.base.file.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.file.dao.FileDataMapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.entity.FileDataExample;
import com.els.base.file.service.FileDataService;

import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("fileDataService")
public class FileDataServiceImpl implements FileDataService {
	@Resource
	protected FileDataMapper fileDataMapper;

	@CacheEvict(value = { "fileData" }, allEntries = true)
	@Override
	public void deleteByExample(FileDataExample example) {
		Assert.isNotNull(example,"删除条件不能为空！");
		Assert.isNotEmpty(example.getOredCriteria(),"不能进行全表删除！");
		this.fileDataMapper.deleteByExample(example);
	}

	@CacheEvict(value = { "fileData" }, allEntries = true)
	@Override
	public void addObj(FileData t) {
		this.fileDataMapper.insertSelective(t);
	}

	@CacheEvict(value = { "fileData" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		this.fileDataMapper.deleteByPrimaryKey(id);
	}

	@CacheEvict(value = { "fileData" }, allEntries = true)
	@Override
	public void modifyObj(FileData t) {
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		this.fileDataMapper.updateByPrimaryKeySelective(t);
	}

	@Cacheable(value = "fileData", keyGenerator = "redisKeyGenerator")
	@Override
	public FileData queryObjById(String id) {
		return this.fileDataMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "fileData", keyGenerator = "redisKeyGenerator")
	@Override
	public List<FileData> queryAllObjByExample(FileDataExample example) {
		return this.fileDataMapper.selectByExample(example);
	}

	@Cacheable(value = "fileData", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<FileData> queryObjByPage(FileDataExample example) {
		PageView<FileData> pageView = example.getPageView();
		pageView.setQueryResult(this.fileDataMapper.selectByExampleByPage(example));
		return pageView;

	}
	
}