package com.els.base.file.utils;

import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import org.apache.commons.lang.time.DateUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;

/**
 * 文件工具类
 */
public class FileDataUtils {

    /**
     * 创建一个临时空的PDF文件
     * @param projectId
     * @param companyId
     * @param fileName
     * @return
     * @throws IOException
     */
    public static FileData createTempEmptyPDF(String projectId, String companyId, String fileName) throws IOException {
        FileData pdfFile=new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(fileName+".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays(new Date(), 2));
        pdfFile= FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), pdfFile);
        return pdfFile;
    }


}
