/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.IFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

public class AwsFileManager
implements IFileManager {
    private static Logger logger = LoggerFactory.getLogger(AwsFileManager.class);
    private static String bucketName;
    private static String keyName;
    private static AmazonS3 s3client;
    private static SecretKey secretKey;
    private static SSECustomerKey sseKey;
    private static String accessKey;
    private static String secretAccessKey;
    private static FileDataService fileDataService;

    @Override
    public FileData write(InputStream in, FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public FileData write(File file, FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public FileData write(MultipartFile multfile, FileData fileData) throws IOException {
        String isEncrypt = fileData.getIsEncrypt();
        if (Integer.parseInt(isEncrypt) == Constant.YES_INT) {
            secretKey = AwsFileManager.generateSecretKey();
            sseKey = new SSECustomerKey(secretKey);
            fileData.setEncryptKey(sseKey.getKey());
        } else {
            sseKey = null;
        }
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileName(multfile.getOriginalFilename());
        fileData.setFileSize(Long.valueOf(multfile.getSize()).intValue());
        fileData.setSaveType(FileSaveTypeEnum.AWS.getSaveType());
        PutObjectResult objectResult = this.serverSideEncryptionPutObject(multfile);
        if (objectResult != null) {
            fileDataService.addObj(fileData);
        }
        return fileData;
    }

    public S3ObjectInputStream read(FileData fileData) {
        String isEncrypt = fileData.getIsEncrypt();
        keyName = fileData.getFileName();
        if (Integer.parseInt(isEncrypt) == Constant.YES_INT) {
            String encryptKey = fileData.getEncryptKey();
            sseKey = new SSECustomerKey(encryptKey);
        } else {
            sseKey = null;
        }
        return this.downloadObject(sseKey);
    }

    @Override
    @Transactional
    public void remove(FileData fileData) {
        String fileId = fileData.getId();
        fileDataService.deleteObjById(fileId);
        keyName = fileData.getFileName();
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, keyName);
        s3client.deleteObject(deleteObjectRequest);
    }

    @Override
    public boolean isExist(FileData fileData) {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return true;
    }

    @Override
    public void init() {
        Properties sysConfig = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        bucketName = sysConfig.getProperty("aws.bucketName");
        accessKey = sysConfig.getProperty("aws.accessKey");
        secretAccessKey = sysConfig.getProperty("aws.secretKey");
        if (StringUtils.isBlank((String)accessKey) || StringUtils.isBlank((String)secretAccessKey) || StringUtils.isBlank((String)bucketName)) {
            logger.warn("\u4e9a\u9a6c\u900aS3\u4e91\u670d\u52a1\u542f\u7528\u5931\u8d25,\u7f3a\u4e4f\u914d\u7f6e\u3002 aws.bucketName[{0}],aws.accessKey[{1}],aws.secretKey[{2}]", (Object[])new String[]{bucketName, accessKey, secretAccessKey});
            return;
        }
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretAccessKey);
        s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.CN_NORTH_1)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    private PutObjectResult serverSideEncryptionPutObject(MultipartFile multfile) throws IOException {
        keyName = multfile.getOriginalFilename();
        PutObjectResult result = this.uploadObject(multfile.getInputStream(), sseKey);
        return result;
    }

    private PutObjectResult uploadObject(InputStream file, SSECustomerKey sseKey) {
        PutObjectRequest putObjectRequest = null;
        ObjectMetadata metadata = new ObjectMetadata();
        putObjectRequest = sseKey == null ? new PutObjectRequest(bucketName, keyName, file, metadata) : new PutObjectRequest(bucketName, keyName, file, metadata).withSSECustomerKey(sseKey);
        PutObjectResult result = s3client.putObject(putObjectRequest);
        return result;
    }

    private static SecretKey generateSecretKey() {
        try {
            SecretKey key = null;
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256, new SecureRandom());
            key = generator.generateKey();
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private S3ObjectInputStream downloadObject(SSECustomerKey sseKey) {
        GetObjectRequest getObjectRequest = null;
        getObjectRequest = sseKey == null ? new GetObjectRequest(bucketName, keyName) : new GetObjectRequest(bucketName, keyName).withSSECustomerKey(sseKey);
        S3Object s3Object = s3client.getObject(getObjectRequest);
        return s3Object.getObjectContent();
    }

    @Override
    public OutputStream createOutputStream(FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public File createEmptyFile(FileData fileData) {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    static {
        fileDataService = (FileDataService)SpringContextHolder.getOneBean(FileDataService.class);
    }
}

