/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.water;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWatermarkUtils {
    public static Logger logger = LoggerFactory.getLogger(ImageWatermarkUtils.class);

    public static void addTextWatermark(String text, File sourceImageFile, File destImageFile) {
        try {
            BufferedImage sourceImage = ImageIO.read(sourceImageFile);
            Graphics2D g2d = (Graphics2D)sourceImage.getGraphics();
            AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.3f);
            g2d.setComposite(alphaChannel);
            g2d.setColor(Color.WHITE);
            g2d.setFont(new Font("Arial", 1, 64));
            FontMetrics fontMetrics = g2d.getFontMetrics();
            Rectangle2D rect = fontMetrics.getStringBounds(text, g2d);
            int centerX = (sourceImage.getWidth() - (int)rect.getWidth()) / 2;
            int centerY = sourceImage.getHeight() / 2;
            g2d.drawString(text, centerX, centerY);
            String extension = FilenameUtils.getExtension((String)destImageFile.getName());
            ImageIO.write((RenderedImage)sourceImage, extension, destImageFile);
            g2d.dispose();
            logger.info("\u6dfb\u52a0\u6c34\u5370\u6210\u529f\uff01");
        }
        catch (IOException ex) {
            logger.info("\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
            logger.error(ex.getMessage());
        }
    }

    static void addImageWatermark(File watermarkImageFile, File sourceImageFile, File destImageFile) {
        try {
            BufferedImage sourceImage = ImageIO.read(sourceImageFile);
            BufferedImage watermarkImage = ImageIO.read(watermarkImageFile);
            Graphics2D g2d = (Graphics2D)sourceImage.getGraphics();
            AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.3f);
            g2d.setComposite(alphaChannel);
            int topLeftX = (sourceImage.getWidth() - watermarkImage.getWidth()) / 2;
            int topLeftY = (sourceImage.getHeight() - watermarkImage.getHeight()) / 2;
            g2d.drawImage((Image)watermarkImage, topLeftX, topLeftY, null);
            String extension = FilenameUtils.getExtension((String)destImageFile.getName());
            ImageIO.write((RenderedImage)sourceImage, extension, destImageFile);
            g2d.dispose();
            logger.info("\u6dfb\u52a0\u6c34\u5370\u6210\u529f\uff01");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info("\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff01");
            logger.error(e.getMessage());
        }
    }

    public static void main(String[] args) {
        File sourceImageFile = new File("D:\\test\\image\\originalimage.jpg");
        File destImageFile = new File("D:\\test\\image\\text_watermarked.jpg");
        ImageWatermarkUtils.addTextWatermark("kangni", sourceImageFile, destImageFile);
        File watermarkImageFile = new File("D:\\test\\image\\logo.png");
        File destImageFile2 = new File("D:\\test\\image\\water_image_marked.jpg");
        ImageWatermarkUtils.addImageWatermark(watermarkImageFile, sourceImageFile, destImageFile2);
    }
}

