/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service.impl;

import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.IFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

public class LocalFileManager
implements IFileManager {
    private static String resourcePath = null;
    private static FileDataService fileDataService = (FileDataService)SpringContextHolder.getOneBean(FileDataService.class);
    private static String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileData write(InputStream in, FileData fileData) throws IOException {
        String relateFolderPath = this.createRelateFolderPath(fileData.getProjectId(), fileData.getCompanyId());
        File saveTarget = this.createSaveTarget(fileData.getFileSuffix(), relateFolderPath);
        Long fileSize = 0L;
        try {
            FileOutputStream output = new FileOutputStream(saveTarget);
            try {
                Integer fileSizeInt = IOUtils.copy((InputStream)in, (OutputStream)output);
                fileSize = fileSizeInt.longValue();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileRename(saveTarget.getName());
        fileData.setLocalRelatPath(relateFolderPath.replaceAll("\\" + File.separator, SEPARATOR));
        fileData.setFileSize(fileSize.intValue());
        fileData.setSaveType(FileSaveTypeEnum.LOCAL.getSaveType());
        String url = "fileData/service/display/" + fileData.getId();
        fileData.setFileUrl(url);
        fileDataService.addObj(fileData);
        return fileData;
    }

    @Override
    public FileData write(File file, FileData fileData) throws IOException {
        String relateFolderPath = this.createRelateFolderPath(fileData.getProjectId(), fileData.getCompanyId());
        File saveTarget = this.createSaveTarget(fileData.getFileSuffix(), relateFolderPath);
        FileUtils.copyFile((File)file, (File)saveTarget);
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileName(file.getName());
        fileData.setFileRename(saveTarget.getName());
        fileData.setLocalRelatPath(relateFolderPath.replaceAll("\\" + File.separator, SEPARATOR));
        fileData.setFileSize(Long.valueOf(FileUtils.readFileToByteArray((File)file).length).intValue());
        fileData.setSaveType(FileSaveTypeEnum.LOCAL.getSaveType());
        String url = "fileData/service/display/" + fileData.getId();
        fileData.setFileUrl(url);
        fileDataService.addObj(fileData);
        return fileData;
    }

    @Override
    public FileData write(MultipartFile file, FileData fileData) throws IOException {
        String relateFolderPath = this.createRelateFolderPath(fileData.getProjectId(), fileData.getCompanyId());
        File saveTarget = this.createSaveTarget(fileData.getFileSuffix(), relateFolderPath);
        file.transferTo(saveTarget);
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileName(file.getOriginalFilename());
        fileData.setFileRename(saveTarget.getName());
        fileData.setLocalRelatPath(relateFolderPath.replaceAll("\\" + File.separator, SEPARATOR));
        fileData.setFileSize(Long.valueOf(file.getSize()).intValue());
        fileData.setSaveType(FileSaveTypeEnum.LOCAL.getSaveType());
        String url = "fileData/service/display/" + fileData.getId();
        fileData.setFileUrl(url);
        fileDataService.addObj(fileData);
        return fileData;
    }

    @Override
    public InputStream read(FileData fileData) throws IOException {
        if (!this.isExist(fileData)) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String fileAbsulutePath = resourcePath + File.separator + fileData.getLocalRelatPath().replaceAll(SEPARATOR, "\\" + File.separator) + fileData.getFileRename();
        File file = new File(fileAbsulutePath);
        return FileUtils.openInputStream((File)file);
    }

    @Override
    @Transactional
    public void remove(FileData fileData) throws IOException {
        fileDataService.deleteObjById(fileData.getId());
        String absoluteFolderRootPath = resourcePath + File.separator;
        String filePath = absoluteFolderRootPath + fileData.getLocalRelatPath() + fileData.getFileRename();
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        FileUtils.forceDelete((File)file);
        String fileFolder = absoluteFolderRootPath + fileData.getLocalRelatPath();
        File folder = new File(fileFolder);
        if (folder.isDirectory() && CollectionUtils.isEmpty((Collection)FileUtils.listFiles((File)folder, null, (boolean)true))) {
            FileUtils.forceDelete((File)folder);
        }
    }

    @Override
    public boolean isExist(FileData fileData) {
        String absoluteFolderRootPath = resourcePath + File.separator;
        String filePath = absoluteFolderRootPath + fileData.getLocalRelatPath() + fileData.getFileRename();
        File file = new File(filePath);
        return file.exists();
    }

    private File createSaveTarget(String fileSuffix, String relateFolderPath) {
        String absoluteFolderRootPath = resourcePath + File.separator;
        String folderPathStr = absoluteFolderRootPath + relateFolderPath;
        File folderPath = new File(folderPathStr);
        if (!folderPath.exists()) {
            folderPath.mkdirs();
        }
        String fileName = String.valueOf(System.currentTimeMillis()) + "_" + (int)(Math.random() * 1.0E9) + "." + fileSuffix;
        File tmp = new File(folderPathStr, fileName);
        return tmp;
    }

    private String createRelateFolderPath(String projectId, String companyId) {
        String relateFolderPath = "project_" + projectId + File.separator + "company_" + companyId + File.separator + DateFormatUtils.format((Date)new Date(), (String)("yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator));
        return relateFolderPath;
    }

    @Override
    public void init() {
        String configResourcePath = SpringContextHolder.getProperty((String)"resource.location");
        if (StringUtils.isBlank((String)configResourcePath)) {
            configResourcePath = System.getProperty("user.home");
        }
        resourcePath = configResourcePath.replaceAll("(\\\\| \\/)$", "");
    }

    @Override
    public OutputStream createOutputStream(FileData fileData) throws IOException {
        String relateFolderPath = this.createRelateFolderPath(fileData.getProjectId(), fileData.getCompanyId());
        File saveTarget = this.createSaveTarget(fileData.getFileSuffix(), relateFolderPath);
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileRename(saveTarget.getName());
        fileData.setLocalRelatPath(relateFolderPath.replaceAll("\\" + File.separator, SEPARATOR));
        fileData.setSaveType(FileSaveTypeEnum.LOCAL.getSaveType());
        String url = "fileData/service/display/" + fileData.getId();
        fileData.setFileUrl(url);
        fileDataService.addObj(fileData);
        FileOutputStream outputStream = new FileOutputStream(saveTarget);
        return outputStream;
    }

    @Override
    public File createEmptyFile(FileData fileData) {
        String relateFolderPath = this.createRelateFolderPath(fileData.getProjectId(), fileData.getCompanyId());
        File saveTarget = this.createSaveTarget(fileData.getFileSuffix(), relateFolderPath);
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileRename(saveTarget.getName());
        fileData.setLocalRelatPath(relateFolderPath.replaceAll("\\" + File.separator, SEPARATOR));
        fileData.setSaveType(FileSaveTypeEnum.LOCAL.getSaveType());
        String url = "fileData/service/display/" + fileData.getId();
        fileData.setFileUrl(url);
        fileDataService.addObj(fileData);
        return saveTarget;
    }
}

