/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.file.dao.FileDataMapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.entity.FileDataExample;
import com.els.base.file.service.FileDataService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fileDataService")
public class FileDataServiceImpl
implements FileDataService {
    @Resource
    protected FileDataMapper fileDataMapper;

    @CacheEvict(value={"fileData"}, allEntries=true)
    public void addObj(FileData t) {
        this.fileDataMapper.insertSelective(t);
    }

    @CacheEvict(value={"fileData"}, allEntries=true)
    public void deleteObjById(String id) {
        this.fileDataMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"fileData"}, allEntries=true)
    public void modifyObj(FileData t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.fileDataMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"fileData"}, keyGenerator="redisKeyGenerator")
    public FileData queryObjById(String id) {
        return this.fileDataMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"fileData"}, keyGenerator="redisKeyGenerator")
    public List<FileData> queryAllObjByExample(FileDataExample example) {
        return this.fileDataMapper.selectByExample(example);
    }

    @Cacheable(value={"fileData"}, keyGenerator="redisKeyGenerator")
    public PageView<FileData> queryObjByPage(FileDataExample example) {
        PageView<FileData> pageView = example.getPageView();
        pageView.setQueryResult(this.fileDataMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"fileData"}, allEntries=true)
    public void deleteByExample(FileDataExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.fileDataMapper.deleteByExample(example);
    }

    @CacheEvict(value={"fileData"}, allEntries=true)
    @Transactional
    public void addAll(List<FileData> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.fileDataMapper.insertSelective((FileData)record));
    }
}

