CREATE TABLE `T_BASE_FILE`
(
    `ID`               varchar(32) NOT NULL COMMENT '主键',
    `PROJECT_ID`       varchar(32)  DEFAULT NULL COMMENT '项目ID',
    `COMPANY_ID`       varchar(32)  DEFAULT NULL COMMENT '公司ID',
    `USER_ID`          varchar(32)  DEFAULT NULL COMMENT '用户ID',
    `FILE_NAME`        varchar(255) DEFAULT NULL COMMENT '附件名称',
    `FILE_RENAME`      varchar(255) DEFAULT NULL COMMENT '文件重命名',
    `FILE_SUFFIX`      varchar(255) DEFAULT NULL COMMENT '文件后缀',
    `FILE_SIZE`        int(11)      DEFAULT NULL COMMENT '文件大小，单位是字节',
    `FILE_URL`         varchar(255) DEFAULT NULL COMMENT '文件连接路径',
    `IS_ENCRYPT`       varchar(1)   DEFAULT NULL COMMENT '是否加密,1加密、0不加密',
    `ENCRYPT_KEY`      varchar(255) DEFAULT NULL COMMENT '是否加密上传文件的密钥',
    `SAVE_TYPE`        int(11)      DEFAULT '1' COMMENT '文件保存的目标地，1本地保存，2阿里云保存，3亚马逊云保存',
    `LOCAL_RELAT_PATH` varchar(255) DEFAULT NULL COMMENT '本地保存的相对路径',
    `CREATE_TIME`      datetime(6)  DEFAULT NULL COMMENT '上传时间',
    `EXPIRY_DAY`       datetime(6)  DEFAULT NULL COMMENT '过期时间',
    `SOURCE_TYPE`      varchar(255) DEFAULT NULL COMMENT '文件来源',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='文件表';
