-- ----------------------------
-- 文件表
-- ----------------------------
-- DROP TABLE "T_BASE_FILE";
CREATE TABLE "T_BASE_FILE"
(
    "ID"               NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"       NVARCHAR2(32),
    "COMPANY_ID"       NVARCHAR2(32),
    "USER_ID"          NVARCHAR2(32),
    "FILE_NAME"        NVARCHAR2(255),
    "FILE_RENAME"      NVARCHAR2(255),
    "FILE_SUFFIX"      NVARCHAR2(255),
    "FILE_SIZE"        NUMBER,
    "FILE_URL"         NVARCHAR2(255),
    "IS_ENCRYPT"       NVARCHAR2(1),
    "ENCRYPT_KEY"      NVARCHAR2(255),
    "SAVE_TYPE"        NUMBER(11) DEFAULT 1,
    "LOCAL_RELAT_PATH" NVARCHAR2(255),
    "CREATE_TIME"      DATE       DEFAULT sysdate,
    "EXPIRY_DAY"       DATE,
    "SOURCE_TYPE"      VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_FILE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_FILE"."FILE_NAME" IS '附件名称';
COMMENT ON COLUMN "T_BASE_FILE"."FILE_RENAME" IS '文件重命名';
COMMENT ON COLUMN "T_BASE_FILE"."FILE_SUFFIX" IS '文件后缀';
COMMENT ON COLUMN "T_BASE_FILE"."FILE_SIZE" IS '文件大小，单位是字节';
COMMENT ON COLUMN "T_BASE_FILE"."FILE_URL" IS '文件连接路径';
COMMENT ON COLUMN "T_BASE_FILE"."IS_ENCRYPT" IS '是否加密';
COMMENT ON COLUMN "T_BASE_FILE"."ENCRYPT_KEY" IS '加密密钥';
COMMENT ON COLUMN "T_BASE_FILE"."SAVE_TYPE" IS '文件保存的目标地，1本地保存，2阿里云保存，3亚马逊云保存';
COMMENT ON COLUMN "T_BASE_FILE"."LOCAL_RELAT_PATH" IS '本地保存的相对路径';
COMMENT ON COLUMN "T_BASE_FILE"."CREATE_TIME" IS '上传时间';
COMMENT ON COLUMN "T_BASE_FILE"."EXPIRY_DAY" IS '过期时间';
COMMENT ON COLUMN "T_BASE_FILE"."SOURCE_TYPE" IS '文件来源';
COMMENT ON TABLE "T_BASE_FILE" IS '文件表';

ALTER TABLE "T_BASE_FILE" ADD PRIMARY KEY ("ID");
