/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.entity.FileDataExample;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.file.service.IFileManager;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.reflect.ReflectUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u6587\u4ef6\u8868")
@Controller
@RequestMapping(value={"fileData"})
public class FileDataController {
    private static Logger logger = LoggerFactory.getLogger(FileDataController.class);
    public static final Long CACHE_EXPIRED_TIME = 2592000000L;
    public static final String DISPLAY_URL_PREFIX = "fileData/service/display/";
    @Value(value="${filepath}")
    private String filePath;
    @Resource
    protected FileDataService fileDataService;

    @ApiOperation(value="\u4e0a\u4f20\u591a\u4e2a\u9644\u4ef6", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isEncrypt", required=false, value="\u662f\u5426\u52a0\u5bc6\uff0c1\u662f\uff0c0\u5426", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="sourceType", required=false, value="\u6587\u4ef6\u7684\u6765\u6e90", paramType="query", dataType="String")})
    @ResponseBody
    @RequestMapping(value={"service/multiUpload"})
    public ResponseResult<List<FileData>> multiUpload(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        String isEncrypt = request.getParameter("isEncrypt");
        String sourceType = request.getParameter("sourceType");
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        Set fileKeySet = fileMap.keySet();
        ArrayList fileList = new ArrayList();
        Iterator keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            fileList.add(fileMap.get(keyIterator.next()));
        }
        ArrayList<FileData> resultList = new ArrayList<FileData>();
        for (MultipartFile file : fileList) {
            String fileSuffix = FilenameUtils.getExtension((String)file.getOriginalFilename());
            if (StringUtils.isBlank((String)fileSuffix)) {
                throw new CommonException("\u4e0d\u63a5\u53d7\u540e\u7f00\u540d\u4e3a\u7a7a\u7684\u6587\u4ef6", "file_upload_not_accepted");
            }
            FileData fileUpload = new FileData();
            fileUpload.setProjectId(ProjectUtils.getProjectId());
            fileUpload.setCompanyId(FileDataController.currentCompanyId());
            fileUpload.setUserId(SpringSecurityUtils.getLoginUserId());
            fileUpload.setFileName(file.getOriginalFilename());
            fileUpload.setFileSuffix(fileSuffix);
            fileUpload.setIsEncrypt(isEncrypt);
            String validDay = request.getParameter("validDay");
            if (StringUtils.isNotBlank((String)validDay) && StringUtils.isNumeric((String)validDay)) {
                long validityTime = Long.valueOf(validDay) * 24L * 60L * 60L * 1000L;
                long time = validityTime + System.currentTimeMillis();
                Date expiryDay = new Date(time);
                fileUpload.setExpiryDay(expiryDay);
            }
            if (StringUtils.isNotBlank((String)sourceType)) {
                fileUpload.setSourceType(sourceType);
            }
            FileData result = FileManagerFactory.getFileManager().write(file, fileUpload);
            resultList.add(result);
        }
        return ResponseResult.success(resultList);
    }

    @ApiOperation(value="\u4e0a\u4f20\u5355\u4e2a\u9644\u4ef6", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isEncrypt", required=false, value="\u662f\u5426\u52a0\u5bc6\uff0c1\u662f\uff0c0\u5426", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="sourceType", required=false, value="\u6587\u4ef6\u7684\u6765\u6e90", paramType="query", dataType="String")})
    @ResponseBody
    @RequestMapping(value={"service/upload"})
    public ResponseResult<FileData> upload(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        String isEncrypt = request.getParameter("isEncrypt");
        String sourceType = request.getParameter("sourceType");
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        Set fileKeySet = fileMap.keySet();
        if (fileKeySet.size() > 1) {
            throw new CommonException("\u4e0d\u63a5\u53d7\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20", "file_upload_not_accepted");
        }
        MultipartFile file = null;
        Iterator keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            file = (MultipartFile)fileMap.get(keyIterator.next());
        }
        if (file == null || file.isEmpty()) {
            throw new CommonException("\u4e0d\u63a5\u53d7\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20", "file_upload_not_accepted");
        }
        String fileSuffix = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (StringUtils.isBlank((String)fileSuffix)) {
            throw new CommonException("\u4e0d\u63a5\u53d7\u540e\u7f00\u540d\u4e3a\u7a7a\u7684\u6587\u4ef6", "file_upload_not_accepted");
        }
        FileData fileUpload = new FileData();
        fileUpload.setProjectId(ProjectUtils.getProjectId());
        fileUpload.setCompanyId(FileDataController.currentCompanyId());
        fileUpload.setUserId(SpringSecurityUtils.getLoginUserId());
        fileUpload.setFileName(file.getOriginalFilename());
        fileUpload.setFileSuffix(fileSuffix.toLowerCase());
        fileUpload.setIsEncrypt(isEncrypt);
        String validDay = request.getParameter("validDay");
        if (StringUtils.isNotBlank((String)validDay) && StringUtils.isNumeric((String)validDay)) {
            long validityTime = Long.valueOf(validDay) * 24L * 60L * 60L * 1000L;
            long time = validityTime + System.currentTimeMillis();
            Date expiryDay = new Date(time);
            fileUpload.setExpiryDay(expiryDay);
        }
        if (StringUtils.isNotBlank((String)sourceType)) {
            fileUpload.setSourceType(sourceType);
        }
        FileData result = FileManagerFactory.getFileManager().write(file, fileUpload);
        result.setInternetPath(this.filePath + result.getFileUrl());
        this.fileDataService.modifyObj(result);
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(value="\u5728\u7ebf\u67e5\u770b\u6587\u4ef6", httpMethod="GET")
    @RequestMapping(value={"service/display/{fileId}", "front/display/{fileId}"})
    public ModelAndView display(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!this.isExpired(request, response)) {
                response.setStatus(304);
                return null;
            }
            FileData fileData = (FileData)this.fileDataService.queryObjById(fileId);
            if (fileData == null) {
                response.setStatus(404);
                return null;
            }
            IFileManager fileManager = FileManagerFactory.getFileManager(fileData.getSaveType());
            if (!fileManager.isExist(fileData)) {
                response.setStatus(404);
                return null;
            }
            response.addHeader("Content-Disposition", "inline;filename=\"" + URLEncoder.encode(fileData.getFileName(), "UTF-8") + "\";");
            if ("png,jpg,jpeg,gif,ico".contains(fileData.getFileSuffix())) {
                response.setContentType("image/" + fileData.getFileSuffix());
            } else if ("pdf".contains(fileData.getFileSuffix())) {
                response.setContentType("application/pdf");
            } else if ("html".contains(fileData.getFileSuffix())) {
                response.setContentType("text/html");
            } else if ("xlsx,xls".contains(fileData.getFileSuffix())) {
                response.setContentType("application/vnd.ms-excel");
            } else if ("doc,docx".contains(fileData.getFileSuffix())) {
                response.setContentType("application/msword");
            }
            this.setRespHeaderCache(response);
            InputStream inputStream = fileManager.read(fileData);
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] tmp = new byte[1024];
            while (inputStream.read(tmp) != -1) {
                outputStream.write(tmp);
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", httpMethod="GET")
    @RequestMapping(value={"service/download/{fileId}", "front/download/{fileId}"})
    @ResponseBody
    public ModelAndView download(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        try {
            IFileManager fileManager;
            FileData fileData = (FileData)this.fileDataService.queryObjById(fileId);
            if (fileData == null) {
                response.setStatus(404);
                return null;
            }
            if ("NPD".equals(fileData.getSourceType())) {
                fileData.setFileName(fileData.getFileName() + "." + fileData.getFileSuffix());
            }
            if (!(fileManager = FileManagerFactory.getFileManager(fileData.getSaveType())).isExist(fileData)) {
                response.setStatus(404);
                return null;
            }
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode(fileData.getFileName(), "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream;charset=UTF-8");
            InputStream inputStream = fileManager.read(fileData);
            ServletOutputStream outputStream = response.getOutputStream();
            int readTmp = 0;
            byte[] tmp = new byte[1024];
            while ((readTmp = inputStream.read(tmp)) != -1) {
                outputStream.write(tmp, 0, readTmp);
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", httpMethod="GET")
    @RequestMapping(value={"service/deletedFile/{fileId}"})
    @ResponseBody
    public ResponseResult<String> deletedFile(@PathVariable String fileId, HttpServletRequest request, HttpServletResponse response) {
        try {
            FileData fileData = (FileData)this.fileDataService.queryObjById(fileId);
            if (fileData == null) {
                response.setStatus(404);
                return null;
            }
            IFileManager fileManager = FileManagerFactory.getFileManager(fileData.getSaveType());
            if (!fileManager.isExist(fileData)) {
                response.setStatus(404);
                return null;
            }
            FileManagerFactory.getFileManager().remove(fileData);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6587\u4ef6\u8868")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<FileData>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FileData") @RequestBody(required=false) QueryParamWapper params) {
        FileDataExample example = new FileDataExample();
        example.setPageView((PageView<FileData>)new PageView(pageNo, pageSize));
        if (params != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)params);
        }
        PageView pageData = this.fileDataService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u6587\u4ef6")
    @RequestMapping(value={"service/deleteByExample"})
    @ResponseBody
    public ResponseResult<Integer> deleteByExample(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FileData") @RequestBody(required=false) QueryParamWapper queryParamWapper) throws IOException {
        List list;
        if (queryParamWapper == null) {
            throw new CommonException("\u7b5b\u9009\u6761\u4ef6\u4e3a\u7a7a");
        }
        FileDataExample example = new FileDataExample();
        if (queryParamWapper != null) {
            FileDataExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.fileDataService.queryAllObjByExample((IExample)example)))) {
            return ResponseResult.success((Object)0);
        }
        for (FileData fileData : list) {
            IFileManager fileManager = FileManagerFactory.getFileManager(fileData.getSaveType());
            fileManager.remove(fileData);
        }
        return ResponseResult.success((Object)list.size());
    }

    private boolean isExpired(HttpServletRequest request, HttpServletResponse response) {
        long header = request.getDateHeader("If-Modified-Since");
        long now = System.currentTimeMillis();
        long expiredTime = 0L;
        if (header > 0L) {
            expiredTime = header + CACHE_EXPIRED_TIME;
        }
        return now > expiredTime;
    }

    private boolean setRespHeaderCache(HttpServletResponse response) {
        String maxAgeDirective = "max-age=" + CACHE_EXPIRED_TIME / 1000L;
        response.setHeader("Cache-Control", maxAgeDirective);
        response.addDateHeader("Last-Modified", System.currentTimeMillis());
        response.addDateHeader("Expires", System.currentTimeMillis() + CACHE_EXPIRED_TIME);
        response.setStatus(200);
        return true;
    }

    public static String currentCompanyId() {
        String userId = SpringSecurityUtils.getLoginUserId();
        if (StringUtils.isBlank((String)userId)) {
            return null;
        }
        String companyId = null;
        try {
            Object companyUserRefService = SpringContextHolder.getOneBean(Class.forName("com.els.base.company.service.CompanyUserRefService"));
            companyId = (String)ReflectUtils.invokeMethod((Object)companyUserRefService, (String)"queryCompanyIdOfUser", (Object[])new Object[]{userId});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("\u83b7\u53d6\u5f53\u524dcompanyid\u5931\u8d25", (Throwable)e);
        }
        return companyId;
    }
}

