/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service;

import com.els.base.file.service.IFileManager;
import com.els.base.file.service.impl.AwsFileManager;
import com.els.base.file.service.impl.LocalFileManager;
import com.els.base.file.service.impl.OssFileManager;
import com.els.base.file.service.impl.PcpFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.HashMap;
import java.util.Map;

public class FileManagerFactory {
    private static Map<Integer, IFileManager> fileManagerMap = new HashMap<Integer, IFileManager>();

    public static IFileManager getFileManager() {
        String saveType = SpringContextHolder.getProperty((String)"resource.save.type", (String)"local");
        switch (saveType.toLowerCase()) {
            case "aws": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.AWS.getSaveType());
            }
            case "oss": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.OSS.getSaveType());
            }
            case "pcp": {
                return FileManagerFactory.getFileManager(FileSaveTypeEnum.PCP.getSaveType());
            }
        }
        return FileManagerFactory.getFileManager(FileSaveTypeEnum.LOCAL.getSaveType());
    }

    public static IFileManager getFileManager(int saveType) {
        return fileManagerMap.get(saveType);
    }

    static {
        LocalFileManager localFileManager = new LocalFileManager();
        localFileManager.init();
        AwsFileManager awsFileManager = new AwsFileManager();
        awsFileManager.init();
        OssFileManager oosFileManager = new OssFileManager();
        oosFileManager.init();
        PcpFileManager pcpFileManager = new PcpFileManager();
        pcpFileManager.init();
        fileManagerMap.put(FileSaveTypeEnum.LOCAL.getSaveType(), localFileManager);
        fileManagerMap.put(FileSaveTypeEnum.AWS.getSaveType(), awsFileManager);
        fileManagerMap.put(FileSaveTypeEnum.OSS.getSaveType(), oosFileManager);
        fileManagerMap.put(FileSaveTypeEnum.PCP.getSaveType(), pcpFileManager);
    }
}

