/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import com.mcoding.base.generator.utils.TableCommentStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;

public class GenerateJspPlugin
extends PluginAdapter {
    private static final String TARGET_PACKAGE = "webapp" + File.separator + "WEB-INF" + File.separator + "view";
    private String targetProject;
    private String moduleName;
    private String modelComment;
    private String modelName;

    public boolean validate(List<String> warnings) {
        this.targetProject = this.properties.getProperty("targetProject");
        if (StringUtils.isBlank((String)this.targetProject)) {
            warnings.add("JSP \u751f\u6210\u5931\u8d25\uff0c targetProject \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        this.moduleName = this.properties.getProperty("moduleName");
        if (StringUtils.isBlank((String)this.moduleName)) {
            warnings.add("JSP \u751f\u6210\u5931\u8d25\uff0c moduleName \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        try {
            this.modelComment = TableCommentStorage.getInstance().get(introspectedTable);
            this.modelName = introspectedTable.getTableConfiguration().getDomainObjectName();
            this.modelName = StringUtils.uncapitalize((String)this.modelName);
            String resource = this.targetProject + File.separator + TARGET_PACKAGE + File.separator + this.moduleName + File.separator + this.modelName;
            File file = new File(resource);
            if (!file.exists()) {
                file.delete();
            }
            file.mkdirs();
            this.generateMainViewJsp(introspectedTable, resource);
            this.generateToAddViewJsp(introspectedTable, resource);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return super.contextGenerateAdditionalJavaFiles(introspectedTable);
    }

    private void generateMainViewJsp(IntrospectedTable introspectedTable, String dirResource) {
        InputStream in = GenerateJspPlugin.class.getClassLoader().getResourceAsStream("template/toMainView_jsp.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            dirResource = dirResource + File.separator + "toMainView.jsp";
            new File(dirResource).createNewFile();
            PrintWriter pw = new PrintWriter(dirResource);
            String line = "";
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("/#modelName#/", this.modelName);
                line = line.replaceAll("/#commentName#/", this.modelComment);
                line = line.replaceAll("/#moduleName#/", this.moduleName);
                line = line.replaceAll("/#baseJspPackage#/", this.modelName);
                pw.println(line);
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateToAddViewJsp(IntrospectedTable introspectedTable, String dirResource) {
        String inputHtml = this.getInputHtml(introspectedTable);
        InputStream in = GenerateJspPlugin.class.getClassLoader().getResourceAsStream("template/toAddView_jsp.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            dirResource = dirResource + File.separator + "toAddView.jsp";
            new File(dirResource).createNewFile();
            PrintWriter pw = new PrintWriter(dirResource);
            String line = "";
            while ((line = br.readLine()) != null) {
                this.modelName = this.modelName.replaceFirst(this.modelName.substring(0, 1), this.modelName.substring(0, 1).toLowerCase());
                line = line.replaceAll("/#modelName#/", this.modelName);
                line = line.replaceAll("/#moduleName#/", this.moduleName);
                line = line.replaceAll("/#commentName#/", this.modelComment);
                line = line.replaceAll("/#inputHtml#/", inputHtml);
                pw.println(line);
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getInputHtml(IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getAllColumns();
        StringBuffer inputHtml = new StringBuffer();
        for (int i = 0; i < columns.size(); ++i) {
            inputHtml.append(this.buildFromTemplate((IntrospectedColumn)columns.get(i), this.modelName));
            inputHtml.append("\n");
        }
        return inputHtml.toString();
    }

    private String buildFromTemplate(IntrospectedColumn introspectedColumn, String modelName) {
        String remark = introspectedColumn.getRemarks();
        String field = introspectedColumn.getJavaProperty();
        remark = StringUtils.isBlank((String)remark) ? introspectedColumn.getActualColumnName() : remark;
        String space = "\t\t\t\t\t\t";
        String template = space + "<div class=\"form-group\"> \n" + space + "    <label class=\"col-md-3 control-label\">" + remark + space + "    </label>\n" + space + "    <div class=\"col-md-9\">\n" + space + "   \t<input type=\"text\" name=\"" + field + "\" value=\"\\$\\{" + modelName + "." + field + "\\}\"\n" + space + "   \t\tclass=\"form-control input-inline input-medium\"\n" + space + "   \t\tplaceholder=\"\u8bf7\u8f93\u5165" + remark + "\" required>\n" + space + "    </div>\n" + space + "</div>";
        return template;
    }
}

