/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import com.mcoding.base.generator.utils.GenerateUtils;
import com.mcoding.base.generator.utils.ServiceGenerateDataStorage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class GenerateServicePlugin
extends PluginAdapter {
    private String targetPackage;
    private String targetProject;
    private boolean isRedisEnable;

    public boolean validate(List<String> warnings) {
        String targetPackage = this.properties.getProperty("targetPackage");
        if (StringUtils.isBlank((String)targetPackage)) {
            warnings.add("Service \u751f\u6210\u5931\u8d25\uff0c targetPackage \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        if (!targetPackage.matches("^(\\w+)(\\.\\w*)*\\w$")) {
            warnings.add("Service \u751f\u6210\u5931\u8d25\uff0c targetPackage[" + targetPackage + "] \u683c\u5f0f\u9519\u8bef");
            return false;
        }
        String targetProject = this.properties.getProperty("targetProject");
        if (StringUtils.isBlank((String)targetProject) && StringUtils.isBlank((String)targetPackage)) {
            warnings.add("Service \u751f\u6210\u5931\u8d25\uff0c targetProject \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        String isRedisEnableStr = this.properties.getProperty("isRedisEnable");
        if (StringUtils.isBlank((String)isRedisEnableStr) || !"false".equals(isRedisEnableStr) && !"true".equals(isRedisEnableStr)) {
            isRedisEnableStr = "true";
        }
        this.isRedisEnable = Boolean.valueOf(isRedisEnableStr);
        this.targetPackage = targetPackage;
        this.targetProject = targetProject;
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        String modelName = introspectedTable.getTableConfiguration().getDomainObjectName();
        GeneratedJavaFile service = new GeneratedJavaFile((CompilationUnit)this.createService(introspectedTable, modelName), this.targetProject, this.context.getJavaFormatter());
        GeneratedJavaFile serviceImpl = new GeneratedJavaFile((CompilationUnit)this.createServiceImpl(introspectedTable, modelName), this.targetProject, this.context.getJavaFormatter());
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>(2);
        list.add(service);
        list.add(serviceImpl);
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        ServiceGenerateDataStorage.getInstance().setServicePackage(tableName, this.targetPackage);
        return list;
    }

    public Interface createService(IntrospectedTable introspectedTable, String modelClassName) {
        String serviceName = this.targetPackage + "." + modelClassName + "Service";
        FullyQualifiedJavaType serviceType = new FullyQualifiedJavaType(serviceName);
        Interface service = new Interface(serviceType);
        service.setVisibility(JavaVisibility.PUBLIC);
        this.addBaseService(service, introspectedTable, modelClassName);
        return service;
    }

    public void addBaseService(Interface service, IntrospectedTable introspectedTable, String modelClassName) {
        service.addImportedType(new FullyQualifiedJavaType("com.els.base.core.service.BaseService"));
        FullyQualifiedJavaType modelType = this.getModelType(introspectedTable, modelClassName);
        service.addImportedType(modelType);
        FullyQualifiedJavaType exampleType = this.getExampleType(introspectedTable, modelClassName);
        service.addImportedType(exampleType);
        String baseServiceStr = "BaseService<" + modelClassName + ", " + modelClassName + "Example, " + GenerateUtils.getIdType(introspectedTable) + ">";
        FullyQualifiedJavaType baseService = new FullyQualifiedJavaType(baseServiceStr);
        service.addSuperInterface(baseService);
    }

    private FullyQualifiedJavaType getModelType(IntrospectedTable introspectedTable, String modelClassName) {
        String beanPackageStr = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage();
        String fullModelClassName = beanPackageStr + "." + modelClassName;
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(fullModelClassName);
        return modelType;
    }

    private FullyQualifiedJavaType getExampleType(IntrospectedTable introspectedTable, String modelClassName) {
        String beanPackageStr = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage();
        String exampleName = modelClassName + "Example";
        String fullExampleNameStr = beanPackageStr + "." + exampleName;
        FullyQualifiedJavaType exampleType = new FullyQualifiedJavaType(fullExampleNameStr);
        return exampleType;
    }

    private FullyQualifiedJavaType getMapperType(IntrospectedTable introspectedTable, String modelClassName) {
        String mapperPackage = introspectedTable.getContext().getSqlMapGeneratorConfiguration().getTargetPackage();
        String mapperFullName = mapperPackage + "." + modelClassName + "Mapper";
        FullyQualifiedJavaType mapperType = new FullyQualifiedJavaType(mapperFullName);
        return mapperType;
    }

    public TopLevelClass createServiceImpl(IntrospectedTable introspectedTable, String className) {
        String serviceImplName = this.targetPackage + ".impl." + className + "ServiceImpl";
        FullyQualifiedJavaType serviceImplType = new FullyQualifiedJavaType(serviceImplName);
        TopLevelClass serviceImpl = new TopLevelClass(serviceImplType);
        serviceImpl.setVisibility(JavaVisibility.PUBLIC);
        String serviceName = this.targetPackage + "." + className + "Service";
        FullyQualifiedJavaType serviceType = new FullyQualifiedJavaType(serviceName);
        serviceImpl.addImportedType(serviceType);
        serviceImpl.addSuperInterface(new FullyQualifiedJavaType(className + "Service"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Service"));
        serviceImpl.addAnnotation("@Service(\"default" + className + "Service\")");
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.springframework.cache.annotation.CacheEvict"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.springframework.cache.annotation.Cacheable"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.springframework.transaction.annotation.Transactional"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("com.els.base.core.entity.PageView"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("com.els.base.core.utils.Assert"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("com.els.base.utils.uuid.UUIDGenerator"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("java.util.List"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.apache.commons.collections.CollectionUtils"));
        serviceImpl.addImportedType(new FullyQualifiedJavaType("org.apache.commons.lang.StringUtils"));
        this.addServiceOverrideMethod(serviceImpl, introspectedTable, className);
        return serviceImpl;
    }

    private void addServiceOverrideMethod(TopLevelClass serviceImpl, IntrospectedTable introspectedTable, String modelClassName) {
        FullyQualifiedJavaType mapperType = this.getMapperType(introspectedTable, modelClassName);
        serviceImpl.addImportedType(mapperType);
        String mapperName = StringUtils.uncapitalize((String)modelClassName) + "Mapper";
        Field mapper = new Field(mapperName, mapperType);
        mapper.setVisibility(JavaVisibility.PROTECTED);
        mapper.addAnnotation("@Resource");
        serviceImpl.addImportedType(new FullyQualifiedJavaType("javax.annotation.Resource"));
        serviceImpl.addField(mapper);
        serviceImpl.addImportedType(this.getModelType(introspectedTable, modelClassName));
        serviceImpl.addImportedType(this.getExampleType(introspectedTable, modelClassName));
        serviceImpl.addMethod(this.methodAddObj(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodAddAll(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodDeleteById(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodDeleteByExample(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodModifyObj(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodQueryObjById(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodQueryAllObjByExample(introspectedTable, modelClassName, mapperName));
        serviceImpl.addMethod(this.methodQueryObjByPage(introspectedTable, modelClassName, mapperName));
    }

    private Method methodAddAll(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method addObj = new Method();
        addObj.setName("addAll");
        addObj.setVisibility(JavaVisibility.PUBLIC);
        addObj.addParameter(new Parameter(new FullyQualifiedJavaType("List<" + modelClassName + ">"), "list"));
        addObj.addBodyLine("if (CollectionUtils.isEmpty(list)) {");
        addObj.addBodyLine("return;");
        addObj.addBodyLine("}");
        if ("String".equals(GenerateUtils.getIdType(introspectedTable))) {
            addObj.addBodyLine("list.stream().forEach(item->{");
            addObj.addBodyLine("if (StringUtils.isBlank(item.getId())) {");
            addObj.addBodyLine("item.setId(UUIDGenerator.generateUUID());");
            addObj.addBodyLine("}");
            addObj.addBodyLine("});");
        }
        addObj.addBodyLine("this." + mapperName + ".insertBatch(list);");
        addObj.addAnnotation("@Transactional");
        if (this.isRedisEnable) {
            addObj.addAnnotation("@CacheEvict(value={\"" + StringUtils.uncapitalize((String)modelClassName) + "\"}, allEntries=true)");
        }
        addObj.addAnnotation("@Override");
        return addObj;
    }

    private Method methodAddObj(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method addObj = new Method();
        addObj.setName("addObj");
        addObj.setVisibility(JavaVisibility.PUBLIC);
        addObj.addParameter(new Parameter(this.getModelType(introspectedTable, modelClassName), "t"));
        String bodyLine = "this." + mapperName + ".insertSelective(t);";
        addObj.addBodyLine(bodyLine);
        if (this.isRedisEnable) {
            addObj.addAnnotation("@CacheEvict(value={\"" + StringUtils.uncapitalize((String)modelClassName) + "\"}, allEntries=true)");
        }
        addObj.addAnnotation("@Override");
        return addObj;
    }

    private Method methodDeleteById(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("deleteObjById");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(new FullyQualifiedJavaType(GenerateUtils.getIdType(introspectedTable)), "id"));
        String bodyLine = "this." + mapperName + ".deleteByPrimaryKey(id);";
        method.addBodyLine(bodyLine);
        if (this.isRedisEnable) {
            method.addAnnotation("@CacheEvict(value={\"" + StringUtils.uncapitalize((String)modelClassName) + "\"}, allEntries=true)");
        }
        method.addAnnotation("@Override");
        return method;
    }

    private Method methodDeleteByExample(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("deleteByExample");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(this.getExampleType(introspectedTable, modelClassName), "example"));
        method.addBodyLine("Assert.isNotNull(example, \"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\");");
        method.addBodyLine("Assert.isNotEmpty(example.getOredCriteria(), \"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664\");");
        String bodyLine = "this." + mapperName + ".deleteByExample(example);";
        method.addBodyLine(bodyLine);
        if (this.isRedisEnable) {
            method.addAnnotation("@CacheEvict(value={\"" + StringUtils.uncapitalize((String)modelClassName) + "\"}, allEntries=true)");
        }
        method.addAnnotation("@Override");
        return method;
    }

    private Method methodModifyObj(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("modifyObj");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(this.getModelType(introspectedTable, modelClassName), "t"));
        if ("String".equals(GenerateUtils.getIdType(introspectedTable))) {
            method.addBodyLine("Assert.isNotBlank(t.getId(), \"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\");");
        } else {
            method.addBodyLine("Assert.isNotNull(t.getId(), \"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539\");");
        }
        method.addBodyLine("this." + mapperName + ".updateByPrimaryKeySelective(t);");
        if (this.isRedisEnable) {
            method.addAnnotation("@CacheEvict(value={\"" + StringUtils.uncapitalize((String)modelClassName) + "\"}, allEntries=true)");
        }
        method.addAnnotation("@Override");
        return method;
    }

    private Method methodQueryObjById(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("queryObjById");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(new FullyQualifiedJavaType(GenerateUtils.getIdType(introspectedTable)), "id"));
        method.setReturnType(this.getModelType(introspectedTable, modelClassName));
        String bodyLine = "return this." + mapperName + ".selectByPrimaryKey(id);";
        method.addBodyLine(bodyLine);
        if (this.isRedisEnable) {
            method.addAnnotation("@Cacheable(value=\"" + StringUtils.uncapitalize((String)modelClassName) + "\", keyGenerator=\"redisKeyGenerator\")");
        }
        method.addAnnotation("@Override");
        return method;
    }

    private Method methodQueryAllObjByExample(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("queryAllObjByExample");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(this.getExampleType(introspectedTable, modelClassName), "example"));
        method.setReturnType(new FullyQualifiedJavaType("List<" + modelClassName + ">"));
        String bodyLine = "return this." + mapperName + ".selectByExample(example);";
        method.addBodyLine(bodyLine);
        if (this.isRedisEnable) {
            method.addAnnotation("@Cacheable(value=\"" + StringUtils.uncapitalize((String)modelClassName) + "\", keyGenerator=\"redisKeyGenerator\")");
        }
        method.addAnnotation("@Override");
        return method;
    }

    private Method methodQueryObjByPage(IntrospectedTable introspectedTable, String modelClassName, String mapperName) {
        Method method = new Method();
        method.setName("queryObjByPage");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(this.getExampleType(introspectedTable, modelClassName), "example"));
        method.setReturnType(new FullyQualifiedJavaType("PageView<" + modelClassName + ">"));
        method.addBodyLine("PageView<" + modelClassName + "> pageView = example.getPageView();");
        method.addBodyLine("pageView.setQueryResult(this." + mapperName + ".selectByExampleByPage(example));");
        method.addBodyLine("return pageView;");
        if (this.isRedisEnable) {
            method.addAnnotation("@Cacheable(value=\"" + StringUtils.uncapitalize((String)modelClassName) + "\", keyGenerator=\"redisKeyGenerator\")");
        }
        method.addAnnotation("@Override");
        return method;
    }
}

