/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import com.mcoding.base.generator.utils.GenerateUtils;
import com.mcoding.base.generator.utils.ServiceGenerateDataStorage;
import com.mcoding.base.generator.utils.TableCommentStorage;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class GenerateControllerPlugin
extends PluginAdapter {
    private String targetPackage;
    private String targetProject;
    private String serviceTargetPackage;
    private String baseUrlPath;
    private String moduleName;

    public boolean validate(List<String> warnings) {
        String targetPackage = this.properties.getProperty("targetPackage");
        if (StringUtils.isBlank((String)targetPackage)) {
            warnings.add("Controller \u751f\u6210\u5931\u8d25\uff0c targetPackage \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        if (!targetPackage.matches("^(\\w+)(\\.\\w*)*\\w$")) {
            warnings.add("Controller \u751f\u6210\u5931\u8d25\uff0c targetPackage[" + targetPackage + "] \u683c\u5f0f\u9519\u8bef");
            return false;
        }
        String targetProject = this.properties.getProperty("targetProject");
        if (StringUtils.isBlank((String)targetProject) && StringUtils.isBlank((String)targetPackage)) {
            warnings.add("Controller \u751f\u6210\u5931\u8d25\uff0c targetProject \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        String baseUrlPath = this.properties.getProperty("baseUrlPath");
        String moduleName = this.properties.getProperty("moduleName");
        moduleName = StringUtils.isBlank((String)moduleName) ? "" : moduleName + "/";
        this.targetPackage = targetPackage;
        this.targetProject = targetProject;
        this.baseUrlPath = baseUrlPath;
        this.moduleName = moduleName;
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        String modelName = introspectedTable.getTableConfiguration().getDomainObjectName();
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        this.serviceTargetPackage = ServiceGenerateDataStorage.getInstance().getServicePackage(tableName);
        if (StringUtils.isBlank((String)this.serviceTargetPackage)) {
            throw new NullPointerException("controller \u751f\u6210\u5931\u8d25\uff0c\u56e0\u4e3a\u5173\u8054\u7684service\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6[GenerateServicePlugin]\u914d\u7f6e\u7684\u987a\u5e8f\u3002");
        }
        GeneratedJavaFile controller = null;
        try {
            controller = new GeneratedJavaFile(this.createController(introspectedTable, modelName), this.targetProject, this.context.getJavaFormatter());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>(2);
        list.add(controller);
        return list;
    }

    private CompilationUnit createController(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String controllerFullName = this.targetPackage + "." + modelClassName + "Controller";
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = modelClassName;
        }
        FullyQualifiedJavaType controllerType = new FullyQualifiedJavaType(controllerFullName);
        TopLevelClass controller = new TopLevelClass(controllerType);
        controller.setVisibility(JavaVisibility.PUBLIC);
        controller.addAnnotation("@Api(tags=\"" + tableComment + "\")");
        controller.addAnnotation("@Controller");
        if (StringUtils.isBlank((String)this.baseUrlPath)) {
            this.baseUrlPath = StringUtils.uncapitalize((String)modelClassName);
        }
        controller.addAnnotation("@RequestMapping(\"" + this.baseUrlPath + "\")");
        List<FullyQualifiedJavaType> importList = this.getImportList(introspectedTable, modelClassName);
        for (FullyQualifiedJavaType importItem : importList) {
            controller.addImportedType(importItem);
        }
        this.addFieldsAndMethod(controller, introspectedTable, modelClassName);
        return controller;
    }

    private void addFieldsAndMethod(TopLevelClass controller, IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        FullyQualifiedJavaType serviceType = this.getServiceType(introspectedTable, modelClassName);
        String serviceName = StringUtils.uncapitalize((String)modelClassName) + "Service";
        Field service = new Field(serviceName, serviceType);
        service.setVisibility(JavaVisibility.PROTECTED);
        service.addAnnotation("@Resource");
        controller.addField(service);
        controller.addMethod(this.methodCreate(introspectedTable, modelClassName));
        controller.addMethod(this.methodEdit(introspectedTable, modelClassName));
        controller.addMethod(this.methodDeleteByIds(introspectedTable, modelClassName));
        controller.addMethod(this.methodFindByPage(introspectedTable, modelClassName));
    }

    private Method methodToAddView(String modelClassName) {
        Method method = new Method();
        method.setName("toAddView");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        String path = this.moduleName + StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("return new ModelAndView(\"" + path + "/toAddView\");");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toAddView\")");
        return method;
    }

    private Method methodToMainView(String modelClassName) {
        Method method = new Method();
        method.setName("toMainView");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        String path = this.moduleName + StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("return new ModelAndView(\"" + path + "/toMainView\");");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toMainView\")");
        return method;
    }

    public Method methodToUpdateViewById(String modelClassName) {
        Method method = new Method();
        method.setName("toUpdateViewById");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        Parameter parameter = new Parameter(new FullyQualifiedJavaType("int"), "id");
        method.addParameter(parameter);
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("ModelAndView view = new ModelAndView();");
        method.addBodyLine(modelClassName + " " + littleModel + " = this." + littleModel + "Service.queryObjById(id);");
        method.addBodyLine("view.addObject(\"" + littleModel + "\", " + littleModel + ");");
        String path = this.moduleName + littleModel;
        method.addBodyLine("view.setViewName(\"" + path + "/toAddView\");");
        method.addBodyLine("return view;");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toUpdateViewById\")");
        return method;
    }

    private Method methodCreate(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("create");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ResponseResult<String>"));
        Parameter parameter = new Parameter(this.getModelType(introspectedTable, modelClassName), littleModel);
        parameter.addAnnotation("@RequestBody");
        method.addParameter(parameter);
        method.addBodyLine("this." + littleModel + "Service.addObj(" + littleModel + ");");
        method.addBodyLine("return ResponseResult.success(" + littleModel + ".getId());");
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = introspectedTable.getTableConfiguration().getDomainObjectName();
        }
        method.addAnnotation("@ApiOperation(httpMethod=\"POST\", value=\"\u521b\u5efa" + tableComment + "\")");
        method.addAnnotation("@RequestMapping(\"service/create\")");
        method.addAnnotation("@ResponseBody");
        return method;
    }

    private Method methodEdit(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("edit");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ResponseResult<String>"));
        Parameter parameter = new Parameter(this.getModelType(introspectedTable, modelClassName), littleModel);
        parameter.addAnnotation("@RequestBody");
        method.addParameter(parameter);
        if ("String".equals(GenerateUtils.getIdType(introspectedTable))) {
            method.addBodyLine(MessageFormat.format("Assert.isNotBlank({0}.getId(), \"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\");", littleModel));
        } else {
            method.addBodyLine(MessageFormat.format("Assert.isNotNull({0}.getId(), \"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\");", littleModel));
        }
        method.addBodyLine("this." + littleModel + "Service.modifyObj(" + littleModel + ");");
        method.addBodyLine("return ResponseResult.success();");
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = introspectedTable.getTableConfiguration().getDomainObjectName();
        }
        method.addAnnotation("@ApiOperation(httpMethod=\"POST\", value=\"\u7f16\u8f91" + tableComment + "\")");
        method.addAnnotation("@RequestMapping(\"service/edit\")");
        method.addAnnotation("@ResponseBody");
        return method;
    }

    private Method methodDeleteByIds(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("deleteByIds");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ResponseResult<String>"));
        String paramType = "String".equals(GenerateUtils.getIdType(introspectedTable)) ? "String" : "int";
        paramType = String.format("List<%s>", paramType);
        Parameter parameter = new Parameter(new FullyQualifiedJavaType(paramType), "ids");
        parameter.addAnnotation("@RequestBody(required=true)");
        method.addParameter(parameter);
        method.addBodyLine("Assert.isNotEmpty(ids, \"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a\");");
        method.addBodyLine(modelClassName + "Example example = new " + modelClassName + "Example();");
        method.addBodyLine("example.createCriteria().andIdIn(ids);");
        method.addBodyLine("this." + littleModel + "Service.deleteByExample(example);");
        method.addBodyLine("return ResponseResult.success();");
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = introspectedTable.getTableConfiguration().getDomainObjectName();
        }
        method.addAnnotation("@ApiOperation(httpMethod=\"POST\", value=\"\u5220\u9664" + tableComment + "\")");
        method.addAnnotation("@RequestMapping(\"service/deleteByIds\")");
        method.addAnnotation("@ResponseBody");
        return method;
    }

    private Method methodFindByPage(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("findByPage");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ResponseResult<PageView<" + modelClassName + ">>"));
        Parameter p1 = new Parameter(new FullyQualifiedJavaType("int"), "pageNo");
        p1.addAnnotation(" \n\t\t@RequestParam(defaultValue=\"0\")");
        method.addParameter(p1);
        Parameter p2 = new Parameter(new FullyQualifiedJavaType("int"), "pageSize");
        p2.addAnnotation(" \n\t\t@RequestParam(defaultValue=\"10\")");
        method.addParameter(p2);
        Parameter p3 = new Parameter(new FullyQualifiedJavaType("QueryParamWapper"), "wapper");
        p3.addAnnotation("\n\t\t@RequestBody(required=false)");
        method.addParameter(p3);
        method.addBodyLine(modelClassName + "Example example = new " + modelClassName + "Example();");
        method.addBodyLine("example.setPageView(new PageView<" + modelClassName + ">(pageNo, pageSize));");
        method.addBodyLine("");
        method.addBodyLine(modelClassName + "Example.Criteria criteria = example.createCriteria();");
        method.addBodyLine("//\u586b\u5199\u5177\u4f53\u7684\u67e5\u8be2\u6761\u4ef6\uff0c\u4f8b\u5982");
        method.addBodyLine("//criteria.andIdEqualTo(\"1\");");
        method.addBodyLine("if (wapper != null) {");
        method.addBodyLine("CriteriaUtils.addExample(example, wapper);");
        method.addBodyLine("}");
        method.addBodyLine("");
        method.addBodyLine("PageView<" + modelClassName + "> pageData = this." + littleModel + "Service.queryObjByPage(example);");
        method.addBodyLine("return ResponseResult.success(pageData);");
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = introspectedTable.getTableConfiguration().getDomainObjectName();
        }
        method.addAnnotation("@ApiOperation(httpMethod=\"POST\", value=\"\u67e5\u8be2" + tableComment + "\")");
        String pageNo = "@ApiImplicitParam( name = \"pageNo\",required = false,value = \"\u6240\u5728\u9875\", paramType = \"query\", dataType = \"String\", defaultValue = \"0\" ), ";
        String pageSize = "@ApiImplicitParam( name = \"pageSize\", required = false, value = \"\u6bcf\u9875\u6570\u91cf\", paramType = \"query\", dataType = \"String\", defaultValue = \"10\" ), ";
        String wapper = "@ApiImplicitParam( name = \"wapper\", required = false, value = \"\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 " + modelClassName + "\", paramType = \"body\", dataType = \"QueryParamWapper\" ) ";
        String annotation = "@ApiImplicitParams({ \n\t\t" + pageNo + " \n\t\t" + pageSize + " \n\t\t" + wapper + " \n\t}) ";
        method.addAnnotation(annotation);
        method.addAnnotation("@RequestMapping(\"service/findByPage\")");
        method.addAnnotation("@ResponseBody");
        return method;
    }

    private List<FullyQualifiedJavaType> getImportList(IntrospectedTable introspectedTable, String modelClassName) {
        ArrayList<FullyQualifiedJavaType> list = new ArrayList<FullyQualifiedJavaType>();
        list.add(new FullyQualifiedJavaType("java.util.List"));
        list.add(new FullyQualifiedJavaType("javax.annotation.Resource"));
        list.add(new FullyQualifiedJavaType("org.apache.commons.lang.StringUtils"));
        list.add(new FullyQualifiedJavaType("org.apache.commons.collections.CollectionUtils"));
        list.add(new FullyQualifiedJavaType("org.springframework.stereotype.Controller"));
        list.add(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RequestBody"));
        list.add(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RequestMapping"));
        list.add(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.ResponseBody"));
        list.add(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RequestParam"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.entity.ResponseResult"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.utils.ResponseCode"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.utils.CriteriaUtils"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.utils.Assert"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.utils.query.QueryParamWapper"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.entity.PageView"));
        list.add(new FullyQualifiedJavaType("com.els.base.core.exception.CommonException"));
        list.add(this.getModelType(introspectedTable, modelClassName));
        list.add(this.getExampleType(introspectedTable, modelClassName));
        list.add(this.getServiceType(introspectedTable, modelClassName));
        list.add(new FullyQualifiedJavaType("io.swagger.annotations.Api"));
        list.add(new FullyQualifiedJavaType("io.swagger.annotations.ApiOperation"));
        list.add(new FullyQualifiedJavaType("io.swagger.annotations.ApiParam"));
        list.add(new FullyQualifiedJavaType("io.swagger.annotations.ApiImplicitParam"));
        list.add(new FullyQualifiedJavaType("io.swagger.annotations.ApiImplicitParams"));
        return list;
    }

    private FullyQualifiedJavaType getModelType(IntrospectedTable introspectedTable, String modelClassName) {
        String beanPackageStr = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage();
        String fullModelClassName = beanPackageStr + "." + modelClassName;
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(fullModelClassName);
        return modelType;
    }

    private FullyQualifiedJavaType getExampleType(IntrospectedTable introspectedTable, String modelClassName) {
        String beanPackageStr = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage();
        String exampleName = modelClassName + "Example";
        String fullExampleNameStr = beanPackageStr + "." + exampleName;
        FullyQualifiedJavaType exampleType = new FullyQualifiedJavaType(fullExampleNameStr);
        return exampleType;
    }

    private FullyQualifiedJavaType getServiceType(IntrospectedTable introspectedTable, String modelClassName) {
        String serviceFullName = this.serviceTargetPackage + "." + modelClassName + "Service";
        FullyQualifiedJavaType mapperType = new FullyQualifiedJavaType(serviceFullName);
        return mapperType;
    }
}

