/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import com.mcoding.base.generator.utils.ServiceGenerateDataStorage;
import com.mcoding.base.generator.utils.TableCommentStorage;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class GenerateTestCasePlugin
extends PluginAdapter {
    private String targetPackage;
    private String targetProject;
    private String serviceTargetPackage;
    private String baseUrlPath;
    private String moduleName;

    public boolean validate(List<String> warnings) {
        String targetPackage = this.properties.getProperty("targetPackage");
        if (StringUtils.isBlank((String)targetPackage)) {
            warnings.add("Controller \u751f\u6210\u5931\u8d25\uff0c targetPackage \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        if (!targetPackage.matches("^(\\w+)(\\.\\w*)*\\w$")) {
            warnings.add("TaseCase \u751f\u6210\u5931\u8d25\uff0c targetPackage[" + targetPackage + "] \u683c\u5f0f\u9519\u8bef");
            return false;
        }
        String targetProject = this.properties.getProperty("targetProject");
        if (StringUtils.isBlank((String)targetProject) && StringUtils.isBlank((String)targetPackage)) {
            warnings.add("TaseCase \u751f\u6210\u5931\u8d25\uff0c targetProject \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        String baseUrlPath = this.properties.getProperty("baseUrlPath");
        String moduleName = this.properties.getProperty("moduleName");
        moduleName = StringUtils.isBlank((String)moduleName) ? "" : moduleName + "/";
        this.targetPackage = targetPackage;
        this.targetProject = targetProject;
        this.baseUrlPath = baseUrlPath;
        this.moduleName = moduleName;
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        String modelName = introspectedTable.getTableConfiguration().getDomainObjectName();
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        this.serviceTargetPackage = ServiceGenerateDataStorage.getInstance().getServicePackage(tableName);
        if (StringUtils.isBlank((String)this.serviceTargetPackage)) {
            throw new NullPointerException("TaseCase \u751f\u6210\u5931\u8d25\uff0c\u56e0\u4e3a\u5173\u8054\u7684service\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u63d2\u4ef6[GenerateServicePlugin]\u914d\u7f6e\u7684\u987a\u5e8f\u3002");
        }
        GeneratedJavaFile testCase = null;
        try {
            testCase = new GeneratedJavaFile(this.createTestCase(introspectedTable, modelName), this.targetProject, this.context.getJavaFormatter());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>(2);
        list.add(testCase);
        return list;
    }

    private CompilationUnit createTestCase(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String testCaseFullName = this.targetPackage + "." + modelClassName + "ControllerTest";
        String tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        if (StringUtils.isBlank((String)tableComment)) {
            tableComment = modelClassName;
        }
        FullyQualifiedJavaType controllerType = new FullyQualifiedJavaType(testCaseFullName);
        TopLevelClass testCase = new TopLevelClass(controllerType);
        testCase.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType superClass = new FullyQualifiedJavaType("BaseTest<" + modelClassName + ">");
        testCase.setSuperClass(superClass);
        testCase.addAnnotation("@SpringBootTest(classes=BaseStarterApplication.class, webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)");
        testCase.addAnnotation("@FixMethodOrder(value = MethodSorters.NAME_ASCENDING)");
        if (StringUtils.isBlank((String)this.baseUrlPath)) {
            this.baseUrlPath = StringUtils.uncapitalize((String)modelClassName);
        }
        List<FullyQualifiedJavaType> importList = this.getImportList(introspectedTable, modelClassName);
        for (FullyQualifiedJavaType importItem : importList) {
            testCase.addImportedType(importItem);
        }
        this.addFieldsAndMethod(testCase, introspectedTable, modelClassName);
        return testCase;
    }

    private void addFieldsAndMethod(TopLevelClass testCase, IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        testCase.addMethod(this.methodTestCreate(introspectedTable, modelClassName));
        testCase.addMethod(this.methodTestEdit(introspectedTable, modelClassName));
        testCase.addMethod(this.methodTestDeleteByIds(introspectedTable, modelClassName));
    }

    private Method methodToAddView(String modelClassName) {
        Method method = new Method();
        method.setName("toAddView");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        String path = this.moduleName + StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("return new ModelAndView(\"" + path + "/toAddView\");");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toAddView\")");
        return method;
    }

    private Method methodToMainView(String modelClassName) {
        Method method = new Method();
        method.setName("toMainView");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        String path = this.moduleName + StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("return new ModelAndView(\"" + path + "/toMainView\");");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toMainView\")");
        return method;
    }

    public Method methodToUpdateViewById(String modelClassName) {
        Method method = new Method();
        method.setName("toUpdateViewById");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("ModelAndView"));
        Parameter parameter = new Parameter(new FullyQualifiedJavaType("int"), "id");
        method.addParameter(parameter);
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        method.addBodyLine("ModelAndView view = new ModelAndView();");
        method.addBodyLine(modelClassName + " " + littleModel + " = this." + littleModel + "Service.queryObjById(id);");
        method.addBodyLine("view.addObject(\"" + littleModel + "\", " + littleModel + ");");
        String path = this.moduleName + littleModel;
        method.addBodyLine("view.setViewName(\"" + path + "/toAddView\");");
        method.addBodyLine("return view;");
        method.addAnnotation("@ApiIgnore");
        method.addAnnotation("@RequestMapping(\"service/toUpdateViewById\")");
        return method;
    }

    private Method methodTestCreate(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("test01Create");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("void"));
        method.addException(new FullyQualifiedJavaType("Exception"));
        method.addAnnotation("@Test");
        method.addBodyLine(modelClassName + " " + littleModel + " = new " + modelClassName + "();");
        method.addBodyLine("ResultActions result = this.create(\"/" + littleModel + "/service/create\", " + littleModel + ");");
        method.addBodyLine("JsonPath jsonPath = JsonPath.compile(\"$.data\");");
        method.addBodyLine("id = jsonPath.read(result.andReturn().getResponse().getContentAsString());");
        method.addBodyLine("Assert.assertNotNull(\"id \u4e3a\u7a7a\uff0c\u521b\u5efa\u5931\u8d25\", id);");
        method.addBodyLine("");
        method.addBodyLine("this.findByPage(\"/" + littleModel + "/service/findByPage\", id)");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult\").isNotEmpty())");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult[0].id\").value(id));");
        return method;
    }

    private Method methodTestEdit(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("test02Edit");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("void"));
        method.addException(new FullyQualifiedJavaType("Exception"));
        method.addAnnotation("@Test");
        method.addBodyLine("Assert.assertNotNull(\"id \u4e0d\u80fd\u4e3a\u7a7a\", id);");
        method.addBodyLine(modelClassName + " " + littleModel + " = new " + modelClassName + "();");
        method.addBodyLine(littleModel + ".setId(id);");
        method.addBodyLine("");
        method.addBodyLine("this.edit(\"/" + littleModel + "/service/edit\", " + littleModel + ");");
        method.addBodyLine("this.findByPage(\"/" + littleModel + "/service/findByPage\", id)");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult\").isNotEmpty())");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult[0].id\").value(id));");
        return method;
    }

    private Method methodTestDeleteByIds(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        String littleModel = StringUtils.uncapitalize((String)modelClassName);
        Method method = new Method();
        method.setName("test03Delete");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(new FullyQualifiedJavaType("void"));
        method.addException(new FullyQualifiedJavaType("Exception"));
        method.addAnnotation("@Test");
        method.addBodyLine("List<String> ids = new ArrayList<>();");
        method.addBodyLine("ids.add(id);");
        method.addBodyLine("");
        method.addBodyLine("this.deleteByIds(\"/" + littleModel + "/service/deleteByIds\", ids);");
        method.addBodyLine("");
        method.addBodyLine("this.findByPage(\"/" + littleModel + "/service/findByPage\", id)");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult\").isEmpty());");
        return method;
    }

    private Method methodFindByPage(IntrospectedTable introspectedTable, String modelClassName) throws SQLException {
        Method method = new Method();
        method.setName("findByPage");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addException(new FullyQualifiedJavaType("Exception"));
        method.setReturnType(new FullyQualifiedJavaType("ResultActions"));
        method.addParameter(new Parameter(new FullyQualifiedJavaType("String"), "url"));
        method.addParameter(new Parameter(new FullyQualifiedJavaType("String"), "id"));
        method.addBodyLine("MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post(url)");
        method.addBodyLine("    .param(\"pageNo\",\"1\").param(\"pageSize\",\"10\")");
        method.addBodyLine("    .contentType(MediaType.APPLICATION_JSON);");
        method.addBodyLine("if (StringUtils.isNotBlank(id)) {");
        method.addBodyLine("    Map<String, String> queryWapper = new HashMap<>();");
        method.addBodyLine("    queryWapper.put(\"id_$_eq\", id);");
        method.addBodyLine("    request.content(JsonUtils.writeValueAsString(queryWapper));");
        method.addBodyLine("ResultActions actions = getMockMvc().perform(request);");
        method.addBodyLine("ResultActions result = actions.andExpect(MockMvcResultMatchers.status().isOk())");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"code\").value(\"200\"))");
        method.addBodyLine("    .andExpect(MockMvcResultMatchers.jsonPath(\"data.queryResult\").exists());");
        method.addBodyLine("return result;");
        return method;
    }

    private List<FullyQualifiedJavaType> getImportList(IntrospectedTable introspectedTable, String modelClassName) {
        List<String> packageStrList = Arrays.asList("java.util.ArrayList", "java.util.List", "org.junit.Assert", "org.junit.FixMethodOrder", "org.junit.Test", "org.junit.runners.MethodSorters", "org.springframework.boot.test.context.SpringBootTest", "org.springframework.test.web.servlet.ResultActions", "org.springframework.test.web.servlet.result.MockMvcResultMatchers", "com.els.base.core.BaseStarterApplication", "com.els.base.test.BaseTest", "com.jayway.jsonpath.JsonPath");
        List<FullyQualifiedJavaType> list = packageStrList.stream().map(FullyQualifiedJavaType::new).collect(Collectors.toList());
        list.add(this.getModelType(introspectedTable, modelClassName));
        return list;
    }

    private FullyQualifiedJavaType getModelType(IntrospectedTable introspectedTable, String modelClassName) {
        String beanPackageStr = introspectedTable.getContext().getJavaModelGeneratorConfiguration().getTargetPackage();
        String fullModelClassName = beanPackageStr + "." + modelClassName;
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(fullModelClassName);
        return modelType;
    }
}

