/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.internal.db.ConnectionFactory;

public class TableCommentStorage {
    private static Pattern pattern = Pattern.compile("COMMENT='(.*)'", 32);
    private static final TableCommentStorage INSTANCE = new TableCommentStorage();
    private static Map<String, String> storage = new Hashtable<String, String>();
    private static Connection connection = null;

    private TableCommentStorage() {
    }

    public static TableCommentStorage getInstance() {
        return INSTANCE;
    }

    public String get(IntrospectedTable introspectedTable) throws SQLException {
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        if (StringUtils.isBlank((String)tableName)) {
            return null;
        }
        String tableComment = storage.get(tableName);
        if (StringUtils.isBlank((String)tableComment)) {
            JDBCConnectionConfiguration configuration = introspectedTable.getContext().getJdbcConnectionConfiguration();
            Connection connection = this.getConnection(configuration);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName().toLowerCase();
            if (databaseProductName.contains("mysql")) {
                tableComment = this.queryCommentOfTableForMysql(connection, tableName);
            } else if (databaseProductName.contains("oracle")) {
                tableComment = this.queryCommentOfTableForOracle(connection, tableName);
            }
            if (StringUtils.isBlank((String)tableComment)) {
                tableComment = tableName;
            }
            storage.put(tableName, tableComment);
        }
        return tableComment;
    }

    private Connection getConnection(JDBCConnectionConfiguration configuration) throws SQLException {
        if (connection == null || connection.isClosed()) {
            connection = ConnectionFactory.getInstance().getConnection(configuration);
        }
        return connection;
    }

    private String queryCommentOfTableForOracle(Connection connection, String tableName) throws SQLException {
        String tableComment = null;
        Statement statement = connection.createStatement();
        String querySql = "select * from user_tab_comments where table_name = '" + tableName + "'";
        try {
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                tableComment = resultSet.getString(3);
            }
        }
        catch (Exception e) {
            System.out.println("\u67e5\u8be2 table[" + tableName + "]\u7684\u6ce8\u89e3\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        if (StringUtils.isBlank(tableComment)) {
            tableComment = tableName;
        }
        return tableComment;
    }

    private String queryCommentOfTableForMysql(Connection connection, String tableName) throws SQLException {
        String tableComment = null;
        Statement statement = connection.createStatement();
        String querySql = "show create table " + tableName;
        try {
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                String createTableSql = resultSet.getString(2);
                Matcher matcher = pattern.matcher(createTableSql);
                if (!matcher.find()) continue;
                tableComment = matcher.group(1);
            }
        }
        catch (Exception e) {
            System.out.println("\u67e5\u8be2 table[" + tableName + "]\u7684\u6ce8\u89e3\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        if (StringUtils.isBlank(tableComment)) {
            tableComment = tableName;
        }
        return tableComment;
    }
}

