/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class InsertBatchElementCreater {
    private String item = "item";
    private IntrospectedTable introspectedTable;
    private String tableName;
    private String column;

    public InsertBatchElementCreater(IntrospectedTable introspectedTable, String tableName) {
        this.introspectedTable = introspectedTable;
        this.tableName = tableName;
    }

    public XmlElement createElement() {
        XmlElement answer = new XmlElement("insert");
        answer.addAttribute(new Attribute("id", "insertBatch"));
        String classFullName = this.introspectedTable.getRules().calculateAllFieldsClass().getFullyQualifiedName();
        answer.addAttribute(new Attribute("parameterType", classFullName));
        this.createInsertStartSql(answer);
        XmlElement foreachElement = this.newForeachElement();
        this.createValueSql(foreachElement);
        answer.addElement((Element)foreachElement);
        answer.addElement((Element)new TextElement(this.createInsertEndSql()));
        return answer;
    }

    private void createValueSql(XmlElement answer) {
        answer.addElement((Element)new TextElement("SELECT"));
        this.getPropertyOrValue(false).forEach(element -> answer.addElement((Element)element));
        answer.addElement((Element)new TextElement("FROM dual"));
    }

    private String createInsertEndSql() {
        return ") T ";
    }

    private void createInsertStartSql(XmlElement answer) {
        StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into ");
        insertClause.append(this.introspectedTable.getFullyQualifiedTableNameAtRuntime());
        insertClause.append(" (");
        answer.addElement((Element)new TextElement(insertClause.toString()));
        this.getPropertyOrValue(true).forEach(element -> answer.addElement((Element)element));
        answer.addElement((Element)new TextElement(")"));
        answer.addElement((Element)new TextElement("select T.* from ( "));
    }

    private List<TextElement> getPropertyOrValue(boolean isProperty) {
        ArrayList<TextElement> propertyStrList = new ArrayList<TextElement>();
        ArrayList<TextElement> valueStrList = new ArrayList<TextElement>();
        StringBuilder insertClause = new StringBuilder();
        StringBuilder valuesClause = new StringBuilder();
        Iterator iter = this.introspectedTable.getAllColumns().iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)iter.next();
            insertClause.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            valuesClause.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)"item.")).append(" AS ").append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            if (!iter.hasNext()) {
                propertyStrList.add(new TextElement(insertClause.toString()));
                valueStrList.add(new TextElement(valuesClause.toString()));
                break;
            }
            insertClause.append(", ");
            valuesClause.append(", ");
            if (valuesClause.length() <= 80) continue;
            propertyStrList.add(new TextElement(insertClause.toString()));
            insertClause.setLength(0);
            OutputUtilities.xmlIndent((StringBuilder)insertClause, (int)1);
            valueStrList.add(new TextElement(valuesClause.toString()));
            valuesClause.setLength(0);
            OutputUtilities.xmlIndent((StringBuilder)valuesClause, (int)1);
        }
        if (isProperty) {
            return propertyStrList;
        }
        return valueStrList;
    }

    public XmlElement newForeachElement() {
        XmlElement foreachElement = new XmlElement("foreach");
        foreachElement.addAttribute(new Attribute("collection", "list"));
        foreachElement.addAttribute(new Attribute("item", this.item));
        foreachElement.addAttribute(new Attribute("index", "index"));
        foreachElement.addAttribute(new Attribute("separator", "UNION ALL"));
        return foreachElement;
    }
}

