package com.mcoding.base.generator;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;

public class InsertSelectiveElementCreater{
	
	private IntrospectedTable introspectedTable;
	private Context context;
	private String identity;
	private String column;
	
	public InsertSelectiveElementCreater(IntrospectedTable introspectedTable, String identity, String column) {
		super();
		this.introspectedTable = introspectedTable;
		this.context = introspectedTable.getContext();
		this.identity = identity;
		this.column = column;
	}

	public XmlElement createElement() {
		XmlElement answer = new XmlElement("insert"); //$NON-NLS-1$

        answer.addAttribute(new Attribute(
                "id", introspectedTable.getInsertSelectiveStatementId())); //$NON-NLS-1$

        FullyQualifiedJavaType parameterType = introspectedTable.getRules()
                .calculateAllFieldsClass();

        answer.addAttribute(new Attribute("parameterType", //$NON-NLS-1$
                parameterType.getFullyQualifiedName()));

        context.getCommentGenerator().addComment(answer);

//        GeneratedKey gk = introspectedTable.getGeneratedKey();
        String bindUUID = "<bind name=\"_uuid\" value=\"@com.els.base.utils.uuid.UUIDGenerator@generateUUIDAndSetId(#this)\"/>";
        if (!identity.equals("id")) {
        	bindUUID = "<bind name=\"_uuid\" value=\"@com.els.base.utils.uuid.UUIDGenerator@generateUUIDAndSetId(#this)\"/>";
        }
        TextElement uuidBindElement = new TextElement(bindUUID);
        answer.addElement(uuidBindElement);

        StringBuilder sb = new StringBuilder();

        sb.append("insert into "); //$NON-NLS-1$
        sb.append(introspectedTable.getFullyQualifiedTableNameAtRuntime());
        answer.addElement(new TextElement(sb.toString()));

        XmlElement insertTrimElement = new XmlElement("trim"); //$NON-NLS-1$
        insertTrimElement.addAttribute(new Attribute("prefix", "(")); //$NON-NLS-1$ //$NON-NLS-2$
        insertTrimElement.addAttribute(new Attribute("suffix", ")")); //$NON-NLS-1$ //$NON-NLS-2$
        insertTrimElement.addAttribute(new Attribute("suffixOverrides", ",")); //$NON-NLS-1$ //$NON-NLS-2$
        answer.addElement(insertTrimElement);

        XmlElement valuesTrimElement = new XmlElement("trim"); //$NON-NLS-1$
        valuesTrimElement.addAttribute(new Attribute("prefix", "values (")); //$NON-NLS-1$ //$NON-NLS-2$
        valuesTrimElement.addAttribute(new Attribute("suffix", ")")); //$NON-NLS-1$ //$NON-NLS-2$
        valuesTrimElement.addAttribute(new Attribute("suffixOverrides", ",")); //$NON-NLS-1$ //$NON-NLS-2$
        answer.addElement(valuesTrimElement);

        for (IntrospectedColumn introspectedColumn : introspectedTable
                .getAllColumns()) {

            if (introspectedColumn.isSequenceColumn()
                    || introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
                // if it is a sequence column, it is not optional
                // This is required for MyBatis3 because MyBatis3 parses
                // and calculates the SQL before executing the selectKey
                
                // if it is primitive, we cannot do a null check
                sb.setLength(0);
                sb.append(MyBatis3FormattingUtilities
                    .getEscapedColumnName(introspectedColumn));
                sb.append(',');
                insertTrimElement.addElement(new TextElement(sb.toString()));

                sb.setLength(0);
                sb.append(MyBatis3FormattingUtilities
                    .getParameterClause(introspectedColumn));
                sb.append(',');
                valuesTrimElement.addElement(new TextElement(sb.toString()));

                continue;
            }            
            
            if (introspectedColumn.isIdentity() || introspectedColumn.getActualColumnName().equalsIgnoreCase(this.column)) {
            	TextElement idElement = new TextElement(MyBatis3FormattingUtilities
	                    .getEscapedColumnName(introspectedColumn) + ",");
	            insertTrimElement.addElement(idElement);
            }else{
				XmlElement insertNotNullElement = new XmlElement("if"); //$NON-NLS-1$
	            sb.setLength(0);
	            sb.append(introspectedColumn.getJavaProperty());
	            sb.append(" != null"); //$NON-NLS-1$
	            insertNotNullElement.addAttribute(new Attribute(
	                    "test", sb.toString())); //$NON-NLS-1$

	            sb.setLength(0);
	            sb.append(MyBatis3FormattingUtilities
	                    .getEscapedColumnName(introspectedColumn));
	            sb.append(',');
	            insertNotNullElement.addElement(new TextElement(sb.toString()));
	            insertTrimElement.addElement(insertNotNullElement);
			}

            if (introspectedColumn.isIdentity() || introspectedColumn.getActualColumnName().equalsIgnoreCase(this.column)) {
            	TextElement idElement = new TextElement("#{_uuid},");
            	valuesTrimElement.addElement(idElement);
            	
            }else{
            	XmlElement valuesNotNullElement = new XmlElement("if"); //$NON-NLS-1$
                sb.setLength(0);
                sb.append(introspectedColumn.getJavaProperty());
                sb.append(" != null"); //$NON-NLS-1$
                valuesNotNullElement.addAttribute(new Attribute(
                        "test", sb.toString())); //$NON-NLS-1$

                sb.setLength(0);
                sb.append(MyBatis3FormattingUtilities
                        .getParameterClause(introspectedColumn));
                sb.append(',');
                valuesNotNullElement.addElement(new TextElement(sb.toString()));
                valuesTrimElement.addElement(valuesNotNullElement);
            }
        }
        return answer;
	}
	
	
}
