/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;

public class GenerateJavaScriptPlugin
extends PluginAdapter {
    private static final String targetPackage = "webapp" + File.separator + "resources" + File.separator + "js" + File.separator + "custom";
    private String targetProject;
    private String recordTemplate = "{ \"sTitle\": \"%s\", \"mData\": \"%s\"},";
    private String modelName;
    private String moduleName;

    public boolean validate(List<String> warnings) {
        this.targetProject = this.properties.getProperty("targetProject");
        if (StringUtils.isBlank((String)this.targetProject)) {
            warnings.add("JS \u751f\u6210\u5931\u8d25\uff0c targetProject \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        this.moduleName = this.properties.getProperty("moduleName");
        if (StringUtils.isBlank((String)this.moduleName)) {
            warnings.add("JSP \u751f\u6210\u5931\u8d25\uff0c moduleName \u914d\u7f6e\u5931\u8d25");
            return false;
        }
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        try {
            this.modelName = introspectedTable.getTableConfiguration().getDomainObjectName();
            this.modelName = this.modelName.replaceFirst(this.modelName.substring(0, 1), this.modelName.substring(0, 1).toLowerCase());
            String resource = this.targetProject + File.separator + targetPackage + File.separator + this.moduleName + File.separator + this.modelName;
            File file = new File(resource);
            if (!file.exists()) {
                file.delete();
            }
            file.mkdirs();
            this.generateMainJs(introspectedTable, resource);
            this.generateAddJs(introspectedTable, resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.contextGenerateAdditionalJavaFiles(introspectedTable);
    }

    private void generateMainJs(IntrospectedTable introspectedTable, String dirResource) {
        List columns = introspectedTable.getAllColumns();
        StringBuilder recordBuilder = new StringBuilder();
        for (IntrospectedColumn column : columns) {
            String remarks = column.getRemarks();
            String property = column.getJavaProperty();
            remarks = StringUtils.isNotBlank((String)remarks) ? remarks : column.getActualColumnName();
            String record = String.format(this.recordTemplate, remarks, property);
            recordBuilder.append("\t\t\t" + record + "\n");
        }
        InputStream in = GenerateJavaScriptPlugin.class.getClassLoader().getResourceAsStream("template/main_js.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            dirResource = dirResource + File.separator + "main.js";
            new File(dirResource).createNewFile();
            PrintWriter pw = new PrintWriter(dirResource);
            String line = "";
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("/#dataColumns#/", recordBuilder.toString());
                line = line.replaceAll("/#modelName#/", this.modelName);
                pw.println(line);
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateAddJs(IntrospectedTable introspectedTable, String dirResource) {
        InputStream in = GenerateJavaScriptPlugin.class.getClassLoader().getResourceAsStream("template/add_js.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            dirResource = dirResource + File.separator + "add.js";
            new File(dirResource).createNewFile();
            PrintWriter pw = new PrintWriter(dirResource);
            String line = "";
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("/#modelName#/", this.modelName);
                pw.println(line);
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

