package com.mcoding.base.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class InsertBatchElementCreater{
	private String item = "item";  
	private IntrospectedTable introspectedTable;
	private String tableName;
	
	//private Context context;
	//private boolean isSimple;
	//private String identity;
	private String column;
	
	public InsertBatchElementCreater(IntrospectedTable introspectedTable, String tableName) {
		super();
		this.introspectedTable = introspectedTable;
		this.tableName = tableName;
	}
	
	public XmlElement createElement() {
		// <insert id="insertBatch" parameterType="com.els.huayang.inquiry.entity.OrderItemDetailL001" >
		
		XmlElement answer = new XmlElement("insert");
        answer.addAttribute(new Attribute("id", "insertBatch"));

        String classFullName = introspectedTable.getRules().calculateAllFieldsClass().getFullyQualifiedName();
        answer.addAttribute(new Attribute("parameterType", classFullName));
        
        // insert into T_ADAYO_INQUIRY_DETAIL_L001 (ID, ORDER_ITEM_ID, SORT_NO, MOULD_CODE .... )
        //   select T.* from(
//        answer.addElement(new TextElement(this.createInsertStartSql()));
        this.createInsertStartSql(answer);
        
        
        // <foreach collection="list" item="item" index="index" separator="UNION ALL" >
        // SELECT #{item.id}, #{item.orderItemId,jdbcType=VARCHAR}, #{item.sortNo,jdbcType=DECIMAL}, #{item.mouldCode,jdbcType=VARCHAR}..
        // </foreach>
        XmlElement foreachElement = newForeachElement();
        this.createValueSql(foreachElement);
        
        answer.addElement(foreachElement);
        
        // ) T
        answer.addElement(new TextElement(createInsertEndSql()));
        return answer;
	}
	
	private void createValueSql(XmlElement answer) {
		answer.addElement(new TextElement("SELECT"));
		this.getPropertyOrValue(false).forEach(element-> answer.addElement(element));
		answer.addElement(new TextElement("FROM dual"));
	}

	private String createInsertEndSql() {
		return ") T ";
	}

	private void createInsertStartSql(XmlElement answer) {
		
		StringBuilder insertClause = new StringBuilder();
        insertClause.append("insert into "); //$NON-NLS-1$
        insertClause.append(introspectedTable.getFullyQualifiedTableNameAtRuntime());
        insertClause.append(" ("); //$NON-NLS-1$
        
        answer.addElement(new TextElement(insertClause.toString()));
        this.getPropertyOrValue(true).forEach(element-> answer.addElement(element));
        
        answer.addElement(new TextElement(")"));
        answer.addElement(new TextElement("select T.* from ( "));
	}
	
	
	private List<TextElement> getPropertyOrValue(boolean isProperty){
		List<TextElement> propertyStrList = new ArrayList<>();
		List<TextElement> valueStrList = new ArrayList<>();
		
		StringBuilder insertClause = new StringBuilder();
		StringBuilder valuesClause = new StringBuilder();
		
		Iterator<IntrospectedColumn> iter = introspectedTable.getAllColumns().iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = iter.next();
            insertClause.append(MyBatis3FormattingUtilities
                    .getEscapedColumnName(introspectedColumn));
            valuesClause.append(MyBatis3FormattingUtilities
                    .getParameterClause(introspectedColumn, "item."))
            	.append(" AS ").append(MyBatis3FormattingUtilities
                    .getEscapedColumnName(introspectedColumn));
            
            if (iter.hasNext()) {
                insertClause.append(", "); //$NON-NLS-1$
                valuesClause.append(", "); //$NON-NLS-1$
            }else {
            	propertyStrList.add(new TextElement(insertClause.toString()));
            	valueStrList.add(new TextElement(valuesClause.toString()) );
            	break;
			}

            if (valuesClause.length() > 80) {
            	propertyStrList.add(new TextElement(insertClause.toString()));
                insertClause.setLength(0);
                OutputUtilities.xmlIndent(insertClause, 1);

                valueStrList.add(new TextElement(valuesClause.toString()) );
                valuesClause.setLength(0);
                OutputUtilities.xmlIndent(valuesClause, 1);
			}
        }
		
		if (isProperty) {
			return propertyStrList;
		}else{
			return valueStrList;
		}
	}


	/** 
     * @return 
     */  
    public XmlElement newForeachElement(){  
        XmlElement foreachElement = new XmlElement("foreach");  
        foreachElement.addAttribute(new Attribute("collection", "list"));  
        foreachElement.addAttribute(new Attribute("item", item));  
        foreachElement.addAttribute(new Attribute("index", "index"));  
        foreachElement.addAttribute(new Attribute("separator", "UNION ALL"));  
        return foreachElement;  
    }  
}
