/*
 * Decompiled with CFR 0.152.
 */
package com.mcoding.base.generator.plugins;

import com.mcoding.base.generator.utils.TableCommentStorage;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.internal.db.ConnectionFactory;

public class ApiModelPlugin
extends PluginAdapter {
    Map<String, String> storage = new Hashtable<String, String>();
    private static Connection connection = null;

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableComment = null;
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        if (tableName.length() > 30) {
            System.out.println("\u3010\u8b66\u544a\u3011table [" + tableName + "] ,\u540d\u5b57\u957f\u5ea6\u5927\u4e8e30\uff0c\u5728Oracle\u4e2d\uff0c\u5c06\u4e0d\u517c\u5bb9");
        }
        try {
            tableComment = TableCommentStorage.getInstance().get(introspectedTable);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        topLevelClass.addImportedType(new FullyQualifiedJavaType("io.swagger.annotations.ApiModel"));
        if (StringUtils.isNotBlank((String)tableComment)) {
            topLevelClass.addAnnotation("@ApiModel(value=\"" + tableComment + "\")");
        } else {
            topLevelClass.addAnnotation("@ApiModel(value=\"" + tableName + "\")");
        }
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String databaseProductName = null;
        String remark = null;
        try {
            JDBCConnectionConfiguration configuration = introspectedColumn.getContext().getJdbcConnectionConfiguration();
            DatabaseMetaData databaseMetaData = this.getConnection(configuration).getMetaData();
            databaseProductName = databaseMetaData.getDatabaseProductName().toLowerCase();
            if (StringUtils.isNotBlank((String)databaseProductName) && databaseProductName.contains("oracle")) {
                remark = this.getRemarkForOracle(introspectedTable, introspectedColumn);
            }
            if (StringUtils.isNotBlank((String)introspectedColumn.getRemarks())) {
                try {
                    remark = new String(introspectedColumn.getRemarks().getBytes(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e1) {
            System.out.println("\u67e5\u8be2\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25");
            e1.printStackTrace();
        }
        if (StringUtils.isNotBlank(remark)) {
            topLevelClass.addImportedType(new FullyQualifiedJavaType("io.swagger.annotations.ApiModelProperty"));
            field.addAnnotation("@ApiModelProperty(\"" + remark + "\")");
        }
        return super.modelFieldGenerated(field, topLevelClass, introspectedColumn, introspectedTable, modelClassType);
    }

    private Connection getConnection(JDBCConnectionConfiguration configuration) throws SQLException {
        if (connection == null || connection.isClosed()) {
            connection = ConnectionFactory.getInstance().getConnection(configuration);
        }
        return connection;
    }

    private String getRemarkForOracle(IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) throws SQLException {
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        String columName = introspectedColumn.getActualColumnName();
        String remark = null;
        String key = tableName + "-" + columName;
        remark = this.storage.get(key);
        if (StringUtils.isNotBlank((String)remark)) {
            return remark;
        }
        Statement statement = this.getConnection(introspectedColumn.getContext().getJdbcConnectionConfiguration()).createStatement();
        String querySql = "select * from user_col_comments WHERE TABLE_NAME = '" + tableName + "'";
        try {
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                if (StringUtils.isBlank((String)resultSet.getString(3))) continue;
                this.storage.put(tableName + "-" + resultSet.getString(2), resultSet.getString(3));
            }
        }
        catch (Exception e) {
            System.out.println("\u67e5\u8be2 table[" + tableName + "]\u7684\u6ce8\u89e3\u5931\u8d25\uff0c\u539f\u56e0\u662f:" + e.getMessage());
        }
        remark = this.storage.get(key);
        if (StringUtils.isNotBlank((String)remark)) {
            return remark;
        }
        return null;
    }
}

