/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.i18n.web;

import com.els.base.utils.i18n.I18nUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

public class UrlParameterLocaleResolver
extends CookieLocaleResolver {
    private static Logger logger = LoggerFactory.getLogger(UrlParameterLocaleResolver.class);
    private static Pattern headerPattern = Pattern.compile("(\\w+-\\w+)\\;\\w=([\\d\\.]+)");
    private static Pattern languagePattern = Pattern.compile("(\\w{2})|(\\w{2}-\\w{2})");

    public String getCookieName() {
        return "COOKIE_I18N";
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale;
        String localStr = request.getParameter("local_i18n");
        if (StringUtils.isBlank((String)localStr)) {
            localStr = this.getLocalStrFromHeader(request.getHeader("Accept-Language"));
        }
        if (StringUtils.isNotBlank((String)localStr)) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)I18nUtils.getByLocale((String)localStr));
        }
        if ((locale = super.resolveLocale(request)) == null) {
            locale = request.getLocale();
        }
        LocaleContextHolder.setLocale((Locale)locale);
        return locale;
    }

    public LocaleContext resolveLocaleContext(HttpServletRequest request) {
        String localStr = request.getParameter("local_i18n");
        if (StringUtils.isNotBlank((String)localStr)) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)I18nUtils.getByLocale((String)localStr));
        }
        LocaleContext localeContext = super.resolveLocaleContext(request);
        LocaleContextHolder.setLocaleContext((LocaleContext)localeContext);
        return localeContext;
    }

    private String getLocalStrFromHeader(String header) {
        if (StringUtils.isBlank((String)header)) {
            return null;
        }
        String[] languageArray = header.split(",");
        HashMap<Double, String> qAndLanguage = new HashMap<Double, String>();
        Double maxQ = 0.0;
        for (String str : languageArray) {
            Double q = 1.0;
            String language = "";
            Matcher matcher = headerPattern.matcher(str);
            if (matcher.find()) {
                language = matcher.group(1);
                String qString = matcher.group(2);
                if (NumberUtils.isNumber((String)str)) {
                    q = Double.valueOf(qString);
                }
            }
            maxQ = q >= maxQ ? q : maxQ;
            qAndLanguage.put(q, language);
        }
        String language = (String)qAndLanguage.get(maxQ);
        if (StringUtils.isBlank((String)language) || !languagePattern.matcher(language).matches()) {
            return null;
        }
        return language;
    }

    public static void main(String[] args) {
        System.out.println("zh".matches("(\\w{2})|(\\w{2}-\\w{2})"));
        System.out.println("zh-TW".matches("(\\w{2})|(\\w{2}-\\w{2})"));
    }
}

