/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.i18n.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.i18n.dao.I18nMapper;
import com.els.base.i18n.entity.I18n;
import com.els.base.i18n.entity.I18nExample;
import com.els.base.i18n.service.I18nService;
import com.els.base.utils.reflect.ReflectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="i18nService")
public class I18nServiceImpl
implements I18nService {
    @Resource
    protected I18nMapper i18nMapper;

    @Override
    @CacheEvict(value={"i18n"}, allEntries=true)
    public void addObj(I18n t) {
        I18nExample example = new I18nExample();
        example.createCriteria().andI18nCodeEqualTo(t.getI18nCode());
        int count = this.i18nMapper.countByExample(example);
        if (count > 0) {
            throw new CommonException("\u56fd\u9645\u5316\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7f16\u7801", "inter_code_already_exists");
        }
        String i18nCode = t.getI18nCode();
        String pattern = "^[a-zA-Z]+[a-zA-Z_]*[a-zA-Z]+$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(i18nCode);
        if (!m.matches()) {
            throw new CommonException("\u56fd\u9645\u5316\u7f16\u7801\u683c\u5f0f\u9519\u8bef", "base_format_error", new Object[]{"\u56fd\u9645\u5316\u7f16\u7801"});
        }
        if (t.getI18nCode() != null && t.getI18nCode().length() > 255 || t.getZhCn() != null && t.getZhCn().length() > 255 || t.getZhTw() != null && t.getZhTw().length() > 255 || t.getJa() != null && t.getJa().length() > 255 || t.getKo() != null && t.getKo().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u8f93\u5165\u7684\u53c2\u6570", "255"});
        }
        this.i18nMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"i18n"}, allEntries=true)
    public void deleteObjById(String id) {
        this.i18nMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"i18n"}, allEntries=true)
    public void modifyObj(I18n t) {
        if (t.getId() == null) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        String i18nCode = t.getI18nCode();
        String pattern = "^[a-zA-Z]+[a-zA-Z_]*[a-zA-Z]+$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(i18nCode);
        if (!m.matches()) {
            throw new CommonException("\u56fd\u9645\u5316\u7f16\u7801\u683c\u5f0f\u9519\u8bef", "base_format_error", new Object[]{"\u56fd\u9645\u5316\u7f16\u7801"});
        }
        if (t.getI18nCode() != null && t.getI18nCode().length() > 255 || t.getZhCn() != null && t.getZhCn().length() > 255 || t.getZhTw() != null && t.getZhTw().length() > 255 || t.getJa() != null && t.getJa().length() > 255 || t.getKo() != null && t.getKo().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255", "length_canot_exceed", new Object[]{"\u8f93\u5165\u7684\u53c2\u6570", "255"});
        }
        this.i18nMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"i18n"}, keyGenerator="redisKeyGenerator")
    public I18n queryObjById(String id) {
        return this.i18nMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"i18n"}, keyGenerator="redisKeyGenerator")
    public List<I18n> queryAllObjByExample(I18nExample example) {
        return this.i18nMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"i18n"}, keyGenerator="redisKeyGenerator")
    public PageView<I18n> queryObjByPage(I18nExample example) {
        PageView<I18n> pageView = example.getPageView();
        pageView.setQueryResult(this.i18nMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"i18n"}, keyGenerator="redisKeyGenerator")
    public String getLocalMessage(String code, String lang, String country) {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)lang)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0ccode:" + code + ", lang:" + lang);
        }
        I18nExample i18nExample = new I18nExample();
        i18nExample.createCriteria().andI18nCodeEqualTo(code).andIsEnableEqualTo(Constant.YES_INT);
        List<I18n> list = this.queryAllObjByExample(i18nExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        I18n i18n = list.get(0);
        boolean hasGetter = this.hasGetter(lang);
        if (hasGetter) {
            return (String)ReflectUtils.getValue((Object)i18n, (String)lang);
        }
        lang = StringUtils.lowerCase((String)lang);
        if (StringUtils.isNotBlank((String)country)) {
            lang = lang + StringUtils.capitalize((String)StringUtils.lowerCase((String)country));
        }
        if (this.hasGetter(lang)) {
            return (String)ReflectUtils.getValue((Object)i18n, (String)lang);
        }
        return null;
    }

    private boolean hasGetter(String lang) {
        String methodName = String.format("get%s", StringUtils.capitalize((String)lang));
        return Arrays.stream(I18n.class.getMethods()).anyMatch(method -> method.getName().equals(methodName));
    }
}

