/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.i18n.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.i18n.entity.I18n;
import com.els.base.i18n.entity.I18nExample;
import com.els.base.i18n.service.I18nService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u56fd\u9645\u5316\u914d\u7f6e\u7ba1\u7406")
@Controller
@RequestMapping(value={"i18n"})
public class I18nController {
    @Resource
    protected I18nService i18nService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u56fd\u9645\u5316\u6d88\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody I18n i18n) {
        this.i18nService.addObj(i18n);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u56fd\u9645\u5316\u6d88\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody I18n i18n) {
        if (i18n.getId() == null) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        this.i18nService.modifyObj(i18n);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u56fd\u9645\u5316\u6d88\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.i18nService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u542f\u7528\u6216\u7981\u7528\u56fd\u9645\u5316\u6d88\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<String> isEnable(@ApiParam(value="\u6d88\u606fid") String id, @ApiParam(value="\u662f\u5426\u542f\u7528:1\u542f\u7528\uff0c0\u7981\u7528") int isEnable) {
        if (isEnable != 0 && isEnable != 1) {
            throw new CommonException("\u65e0\u6cd5\u8bc6\u522b\u662f\u542f\u7528\u8fd8\u662f\u7981\u7528", "unrecognized");
        }
        I18n i18n = new I18n();
        i18n.setId(id);
        i18n.setIsEnable(isEnable);
        this.i18nService.modifyObj(i18n);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u56fd\u9645\u5316\u6d88\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<I18n>> findByPage(HttpServletRequest request, @ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        PageView pageView = new PageView(pageNo, pageSize);
        I18nExample example = new I18nExample();
        example.setPageView((PageView<I18n>)pageView);
        example.setOrderByClause("ID DESC");
        I18nExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        PageView<I18n> pageData = this.i18nService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

