-- ----------------------------
-- 国际化表
-- ----------------------------
-- DROP TABLE "T_BASE_I18N";
CREATE TABLE "T_BASE_I18N"
(
    "IS_ENABLE" NUMBER(11) DEFAULT 1,
    "I18N_CODE" NVARCHAR2(255)    NOT NULL,
    "ZH_CN"     NVARCHAR2(255)    NOT NULL,
    "ZH_TW"     NVARCHAR2(255),
    "EN"        NVARCHAR2(255),
    "JA"        NVARCHAR2(255),
    "KO"        NVARCHAR2(255),
    "ID"        VARCHAR2(32 BYTE) NOT NULL
);

COMMENT ON COLUMN "T_BASE_I18N"."IS_ENABLE" IS '是否可用，1可用，0禁用';
COMMENT ON COLUMN "T_BASE_I18N"."I18N_CODE" IS '国际化的代码';
COMMENT ON COLUMN "T_BASE_I18N"."ZH_CN" IS '中文简体';
COMMENT ON COLUMN "T_BASE_I18N"."ZH_TW" IS '中文繁体';
COMMENT ON COLUMN "T_BASE_I18N"."EN" IS '英文';
COMMENT ON COLUMN "T_BASE_I18N"."ID" IS '主键';

COMMENT ON TABLE "T_BASE_I18N" IS '国际化表';

ALTER TABLE "T_BASE_I18N" ADD PRIMARY KEY ("ID");














