/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.im.entity.ImTemplate;
import com.els.base.msg.im.entity.ImTemplateExample;
import com.els.base.msg.im.service.ImTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="im\u6d88\u606f\u6a21\u677f")
@Controller
@RequestMapping(value={"imTemplate"})
public class ImTemplateController {
    @Resource
    protected ImTemplateService imTemplateService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaim\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ImTemplate imTemplate) {
        Assert.isNotNull((Object)imTemplate, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        imTemplate.setProjectId(ProjectUtils.getProjectId());
        imTemplate.setCompanyId(CompanyUtils.currentCompanyId());
        imTemplate.setCreateUser(SpringSecurityUtils.getLoginUser().getNickName());
        this.imTemplateService.addObj(imTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91im\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ImTemplate imTemplate) {
        Assert.isNotBlank((String)imTemplate.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.imTemplateService.modifyObj(imTemplate);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664im\u6d88\u606f\u6a21\u677f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.imTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2im\u6d88\u606f\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ImTemplate", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ImTemplate>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ImTemplateExample example = new ImTemplateExample();
        example.setPageView((PageView<ImTemplate>)new PageView(pageNo, pageSize));
        ImTemplateExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.imTemplateService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

