/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.utils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.utils.encryption.DESUtils;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendMailUtil {
    public static void sendMail(MailAccount senderMailAccount, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws Exception {
        String smtpHost = senderMailAccount.getStmpServerHost();
        Integer smtpPort = senderMailAccount.getStmpServerPort();
        boolean isSSL = Constant.YES_INT.equals(senderMailAccount.getStmpServerIsSsl());
        String senderMailAddress = senderMailAccount.getMailAddress();
        String password = senderMailAccount.getPassword();
        password = DESUtils.decrypt((String)password, (String)"tissonco");
        String senderName = senderMailAccount.getUserName();
        SendMailUtil.sendMail(smtpHost, smtpPort, isSSL, senderMailAddress, password, senderName, receiveEmailAddress, receiveName, subject, mailContent);
    }

    public static void sendMail(String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress, String password, String senderName, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws MessagingException, UnsupportedEncodingException {
        Assert.isNotBlank((String)senderMailAddress, (String)"\u53d1\u9001\u7684\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)senderName, (String)"\u53d1\u4ef6\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)receiveEmailAddress, (String)"\u6536\u4ef6\u7684\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)receiveName, (String)"\u6536\u4ef6\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)smtpHost, (String)"STMP\u670d\u52a1\u5668\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)smtpPort, (String)"STMP\u670d\u52a1\u5668\u7aef\u53e3 \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)subject, (String)"\u90ae\u4ef6\u6807\u9898 \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailContent, (String)"\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        final Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", smtpHost);
        if (isSSL) {
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.port", (Object)smtpPort);
            props.put("mail.smtp.port", (Object)smtpPort);
        } else {
            props.put("mail.smtp.port", (Object)smtpPort);
        }
        props.put("mail.user", senderMailAddress);
        props.put("mail.password", password);
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String userName = props.getProperty("mail.user");
                String password = props.getProperty("mail.password");
                return new PasswordAuthentication(userName, password);
            }
        };
        Session mailSession = Session.getInstance((Properties)props, (Authenticator)authenticator);
        InternetAddress form = new InternetAddress(senderMailAddress, senderName, "UTF-8");
        InternetAddress to = new InternetAddress(receiveEmailAddress, receiveName, "UTF-8");
        MimeMessage message = new MimeMessage(mailSession);
        message.setFrom((Address)form);
        message.setRecipient(MimeMessage.RecipientType.TO, (Address)to);
        message.setSubject(subject);
        message.setContent((Object)mailContent, "text/html;charset=UTF-8");
        Transport transport = mailSession.getTransport();
        transport.connect(senderMailAddress, password);
        transport.sendMessage((Message)message, new Address[]{to});
        transport.close();
    }
}

