/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.command.IMsgCommand;
import com.els.base.notice.command.ImInvoker;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
implements IMsgCommand<String> {
    private static final String GERNERATOR_CODE = "NOTICE_NO_GENERATOR";
    private Notice notice;

    public CreateCommand(Notice notice) {
        this.notice = notice;
    }

    @Override
    public String execute(ImInvoker invoker) {
        this.valid(this.notice);
        this.init(this.notice);
        this.add(this.notice);
        return null;
    }

    private void add(Notice notice2) {
        this.getNoticeService().addObj(notice2);
        if (Constant.YES_INT.equals(notice2.getIsAllReceived())) {
            return;
        }
        String noticeId = notice2.getId();
        ArrayList<String> companyIdList = new ArrayList<String>();
        for (NoticeReceiver company : notice2.getReceiverIdList()) {
            companyIdList.add(company.getReceiverCompanyId());
        }
        this.getNoticeReceiverService().addAll(noticeId, companyIdList);
    }

    private NoticeReceiverService getNoticeReceiverService() {
        return (NoticeReceiverService)SpringContextHolder.getOneBean(NoticeReceiverService.class);
    }

    private NoticeService getNoticeService() {
        return (NoticeService)SpringContextHolder.getOneBean(NoticeService.class);
    }

    private void init(Notice notice) {
        notice.setCreateTime(new Date());
        notice.setStatus(Constant.NO_INT);
        if (!Constant.YES_INT.equals(notice.getIsAllReceived()) && !Constant.NO_INT.equals(notice.getIsAllReceived())) {
            notice.setIsAllReceived(Constant.YES_INT);
        }
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        notice.setNoticeNo(generateCodeService.getNextCode(GERNERATOR_CODE));
    }

    private void valid(Notice notice) {
        Assert.isNotBlank((String)notice.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)notice.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)notice.getType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)notice.getCreateUserId(), (String)"\u521b\u5efa\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)notice.getCreateUserName(), (String)"\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        if (notice.getValidStartTime() != null && notice.getValidEndTime() != null && notice.getValidStartTime().getTime() > notice.getValidEndTime().getTime()) {
            throw new CommonException("\u5f00\u59cb\u751f\u6548\u65f6\u95f4\uff0c\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        ArrayList<NoticeReceiver> blankIds = new ArrayList<NoticeReceiver>();
        if (Constant.NO_INT.equals(notice.getIsAllReceived()) && CollectionUtils.isNotEmpty(notice.getReceiverIdList())) {
            for (NoticeReceiver receiverId : notice.getReceiverIdList()) {
                if (!StringUtils.isBlank((String)receiverId.getReceiverCompanyId())) continue;
                blankIds.add(receiverId);
            }
            notice.getReceiverIdList().removeAll(blankIds);
        }
        if (Constant.NO_INT.equals(notice.getIsAllReceived()) && CollectionUtils.isEmpty(notice.getReceiverIdList())) {
            throw new CommonException("\u6307\u5b9a\u7684\u63a5\u6536\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

