/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.weixin;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.utils.encryption.DESUtils;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.oauth.service.WechatOauthService;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class LoginByOpenidService
implements WechatOauthService {
    private static Logger logger = LoggerFactory.getLogger(LoginByOpenidService.class);
    @Autowired
    private WxMemberService wxMemberService;
    @Autowired
    private UserService userService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected AuthenticationManager authenticationManager;

    public void handleForOpenId(String openId, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        WxMember wxMember = this.wxMemberService.queryByOpenId(openId);
        if (wxMember == null) {
            logger.warn("\u6839\u636eopenid \u67e5\u627e wxMember\u5931\u8d25\u3002 openid:{}", (Object)openId);
            return;
        }
        if (StringUtils.isBlank((String)wxMember.getMemberId())) {
            logger.warn("wxMember \u6ca1\u6709\u7ed1\u5b9aMemberId\u3002 openid:{}", (Object)openId);
            return;
        }
        User user = (User)this.userService.queryObjById((Object)wxMember.getMemberId());
        if (user == null) {
            logger.warn("wxMember \u7ed1\u5b9a\u7684User \u4e3a\u7a7a\u3002userId{}, openid:{}", (Object)wxMember.getMemberId(), (Object)openId);
            return;
        }
        this.loginByUser(user, request, response);
    }

    public void handleForWxUser(WxMpUser wxMpUser, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        this.handleForOpenId(wxMpUser.getOpenId(), paramsMap, request, response);
    }

    private void loginByUser(User user, HttpServletRequest request, HttpServletResponse response) {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getLoginName(), (Object)this.getPassword(user));
        Authentication authResult = this.authenticationManager.authenticate((Authentication)authentication);
        com.els.base.auth.entity.User userAuthed = (com.els.base.auth.entity.User)authResult.getPrincipal();
        ArrayList<SimpleGrantedAuthority> roleList = new ArrayList<SimpleGrantedAuthority>();
        for (Role grantedAuthority : this.roleService.queryUserOwnRoles(user.getId())) {
            roleList.add(new SimpleGrantedAuthority(grantedAuthority.getRoleName()));
        }
        userAuthed.setAuthorities(roleList);
        SecurityContextHolder.getContext().setAuthentication(authResult);
    }

    private String getPassword(User user) {
        Assert.isNotBlank((String)user.getPassword(), (String)"\u5e10\u53f7\u5f02\u5e38");
        String password = null;
        try {
            password = DESUtils.decrypt((String)user.getPassword(), (String)"tissonco");
            if (StringUtils.isNotBlank((String)user.getPasswordKey())) {
                password = password.replace(user.getPasswordKey(), "");
                password = DESUtils.decrypt((String)password, (String)"tissonco");
            }
        }
        catch (Exception e) {
            throw new CommonException("\u5e10\u53f7\u5f02\u5e38", (Throwable)e);
        }
        return password;
    }
}

