/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.common.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.Message;
import com.els.base.msg.common.dao.MsgConfigMapper;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.msg.im.ImMessageCommand;
import com.els.base.msg.mail.MailMessageCommand;
import com.els.base.msg.weixin.WeixinMessageCommand;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMsgConfigService")
public class MsgConfigServiceImpl
implements MsgConfigService {
    @Resource
    protected MsgConfigMapper msgConfigMapper;

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    public void addObj(MsgConfig msgConfig) {
        Assert.isNotBlank((String)msgConfig.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MsgConfigExample example = new MsgConfigExample();
        example.createCriteria().andBusinessTypeEqualTo(msgConfig.getBusinessType());
        if (this.msgConfigMapper.countByExample(example) > 0) {
            throw new CommonException("\u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u7ecf\u914d\u7f6e\u89c4\u5219\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
        }
        if (msgConfig.getIsEnable() == null || !Constant.NO_INT.equals(msgConfig.getIsEnable())) {
            msgConfig.setIsEnable(Constant.YES_INT);
        }
        if (msgConfig.getSysMsg() == null || !Constant.YES_INT.equals(msgConfig.getSysMsg())) {
            msgConfig.setSysMsg(Constant.NO_INT);
        }
        if (msgConfig.getWeixinMsg() == null || !Constant.YES_INT.equals(msgConfig.getWeixinMsg())) {
            msgConfig.setWeixinMsg(Constant.NO_INT);
        }
        if (msgConfig.getMailMsg() == null || !Constant.YES_INT.equals(msgConfig.getMailMsg())) {
            msgConfig.setMailMsg(Constant.NO_INT);
        }
        if (msgConfig.getSmsMsg() == null || !Constant.YES_INT.equals(msgConfig.getSmsMsg())) {
            msgConfig.setSmsMsg(Constant.NO_INT);
        }
        if (msgConfig.getAppMsg() == null || !Constant.YES_INT.equals(msgConfig.getAppMsg())) {
            msgConfig.setAppMsg(Constant.NO_INT);
        }
        msgConfig.setUpdateTime(new Date());
        this.msgConfigMapper.insertSelective(msgConfig);
    }

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    public void deleteObjById(String id) {
        this.msgConfigMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"msgConfig"}, allEntries=true)
    public void modifyObj(MsgConfig msgConfig) {
        Assert.isNotBlank((String)msgConfig.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        if (StringUtils.isNotBlank((String)msgConfig.getBusinessType())) {
            MsgConfigExample example = new MsgConfigExample();
            example.createCriteria().andBusinessTypeEqualTo(msgConfig.getBusinessType()).andIdNotEqualTo(msgConfig.getId());
            if (this.msgConfigMapper.countByExample(example) > 0) {
                throw new CommonException("\u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u7ecf\u914d\u7f6e\u89c4\u5219\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
            }
        }
        if (msgConfig.getSysMsg() == null || !Constant.YES_INT.equals(msgConfig.getSysMsg())) {
            msgConfig.setSysMsg(Constant.NO_INT);
        }
        if (msgConfig.getWeixinMsg() == null || !Constant.YES_INT.equals(msgConfig.getWeixinMsg())) {
            msgConfig.setWeixinMsg(Constant.NO_INT);
        }
        if (msgConfig.getMailMsg() == null || !Constant.YES_INT.equals(msgConfig.getMailMsg())) {
            msgConfig.setMailMsg(Constant.NO_INT);
        }
        if (msgConfig.getSmsMsg() == null || !Constant.YES_INT.equals(msgConfig.getSmsMsg())) {
            msgConfig.setSmsMsg(Constant.NO_INT);
        }
        if (msgConfig.getAppMsg() == null || !Constant.YES_INT.equals(msgConfig.getAppMsg())) {
            msgConfig.setAppMsg(Constant.NO_INT);
        }
        msgConfig.setUpdateTime(new Date());
        this.msgConfigMapper.updateByPrimaryKeySelective(msgConfig);
    }

    @Cacheable(value={"msgConfig"}, keyGenerator="redisKeyGenerator")
    public MsgConfig queryObjById(String id) {
        return this.msgConfigMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"msgConfig"}, keyGenerator="redisKeyGenerator")
    public List<MsgConfig> queryAllObjByExample(MsgConfigExample example) {
        return this.msgConfigMapper.selectByExample(example);
    }

    @Cacheable(value={"msgConfig"}, keyGenerator="redisKeyGenerator")
    public PageView<MsgConfig> queryObjByPage(MsgConfigExample example) {
        PageView<MsgConfig> pageView = example.getPageView();
        pageView.setQueryResult(this.msgConfigMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"msgConfig"}, keyGenerator="redisKeyGenerator")
    public List<IMessageCommand> querySender(Message<?> message) {
        MsgConfigExample example = new MsgConfigExample();
        example.createCriteria().andBusinessTypeEqualTo(message.getBusinessTypeCode()).andIsEnableEqualTo(Constant.YES_INT);
        List<MsgConfig> list = this.msgConfigMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ImMessageCommand imCommand = new ImMessageCommand();
        MailMessageCommand mailCommand = new MailMessageCommand();
        WeixinMessageCommand weixinCommand = new WeixinMessageCommand();
        ArrayList<IMessageCommand> commandList = new ArrayList<IMessageCommand>();
        for (MsgConfig config : list) {
            if (Constant.YES_INT.equals(config.getSysMsg()) && !commandList.contains(imCommand)) {
                commandList.add(imCommand);
            }
            if (Constant.YES_INT.equals(config.getMailMsg()) && !commandList.contains(mailCommand)) {
                commandList.add(mailCommand);
            }
            if (!Constant.YES_INT.equals(config.getWeixinMsg()) || commandList.contains(weixinCommand)) continue;
            commandList.add(weixinCommand);
        }
        return commandList;
    }

    @Override
    @CacheEvict(value={"msgConfig"}, allEntries=true)
    public void disableMsgConfig(List<String> ids, int isEnable) {
        Assert.isNotEmpty(ids, (String)"\u53d1\u9001\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        MsgConfigExample example = new MsgConfigExample();
        example.createCriteria().andIdIn((List)ids);
        MsgConfig temp = new MsgConfig();
        temp.setIsEnable(Constant.YES_INT.equals(isEnable) ? Constant.YES_INT : Constant.NO_INT);
        this.msgConfigMapper.updateByExampleSelective(temp, example);
    }

    @Override
    @CacheEvict(value={"msgConfig"}, allEntries=true)
    @Transactional
    public void modifyObj(List<MsgConfig> msgConfigList) {
        if (CollectionUtils.isEmpty(msgConfigList)) {
            throw new CommonException("\u6d88\u606f\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (MsgConfig msgConfig : msgConfigList) {
            msgConfig.setBusinessType(null);
            msgConfig.setIsEnable(null);
            this.modifyObj(msgConfig);
        }
    }
}

