package com.els.base.msg.common.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.utils.json.IntegerFromBooleanDeserializer;
import com.els.base.utils.json.IntegerToBooleanSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="消息发送配置")
public class MsgConfig implements Serializable {
    @ApiModelProperty("主键")  
    private String id;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("修改人")
    private String updateUserId;

    private String updateUserName;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("是否启用: 0,启用 1,不启用")
    private Integer isEnable;

    @ApiModelProperty("消息级别")
    private Integer msgLevel;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("是否支持系统消息,1支持0不支持")
    private Integer sysMsg;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("是否支持邮箱消息,1支持0不支持")
    private Integer mailMsg;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("是否支持微信消息,1支持0不支持")
    private Integer weixinMsg;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("是否支持短信消息,1支持0不支持")
    private Integer smsMsg;

    @JsonSerialize(using=IntegerToBooleanSerializer.class)
    @JsonDeserialize(using=IntegerFromBooleanDeserializer.class)
    @ApiModelProperty("是否支持app端消息,1支持0不支持")
    private Integer appMsg;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType == null ? null : businessType.trim();
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId == null ? null : updateUserId.trim();
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getMsgLevel() {
        return msgLevel;
    }

    public void setMsgLevel(Integer msgLevel) {
        this.msgLevel = msgLevel;
    }

    public Integer getSysMsg() {
        return sysMsg;
    }

    public void setSysMsg(Integer sysMsg) {
        this.sysMsg = sysMsg;
    }

    public Integer getMailMsg() {
        return mailMsg;
    }

    public void setMailMsg(Integer mailMsg) {
        this.mailMsg = mailMsg;
    }

    public Integer getWeixinMsg() {
        return weixinMsg;
    }

    public void setWeixinMsg(Integer weixinMsg) {
        this.weixinMsg = weixinMsg;
    }

    public Integer getSmsMsg() {
        return smsMsg;
    }

    public void setSmsMsg(Integer smsMsg) {
        this.smsMsg = smsMsg;
    }

    public Integer getAppMsg() {
        return appMsg;
    }

    public void setAppMsg(Integer appMsg) {
        this.appMsg = appMsg;
    }
}