package com.els.base.msg.im.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.msg.im.dao.ImTemplateMapper;
import com.els.base.msg.im.entity.ImTemplate;
import com.els.base.msg.im.entity.ImTemplateExample;
import com.els.base.msg.im.service.ImTemplateService;

@Service("defaultImTemplateService")
public class ImTemplateServiceImpl implements ImTemplateService {
    @Resource
    protected ImTemplateMapper imTemplateMapper;

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    @Override
    public void addObj(ImTemplate imTemplate) {
    	if ((imTemplate.getTemplateNo() != null && imTemplate.getTemplateNo().length() > 255)
    		|| imTemplate.getTemplateTitle() != null && imTemplate.getTemplateTitle().length() > 255
            || imTemplate.getTemplateName() != null && imTemplate.getTemplateName().length() > 255) {
    		throw new CommonException("输入的参数长度超标", "database_length_error");
    	}
		if (!imTemplate.getBusinessType().matches("[\\w\\_]+")) {
			throw new CommonException("业务类型的格式错误");
		}
		ImTemplateExample example = new ImTemplateExample();
		example.createCriteria().andProjectIdEqualTo(imTemplate.getProjectId())
		.andCompanyIdEqualTo(imTemplate.getCompanyId())
		.andBusinessTypeEqualTo(imTemplate.getBusinessType());
		if (this.imTemplateMapper.countByExample(example) > 0) {
			throw new CommonException("业务类型已经存在，不可重复", "base_is_exists", "业务类型");
		}
		example.clear();
		example.createCriteria().andProjectIdEqualTo(imTemplate.getProjectId())
            .andCompanyIdEqualTo(imTemplate.getCompanyId())
            .andTemplateNoEqualTo(imTemplate.getTemplateNo());
		if (this.imTemplateMapper.countByExample(example) > 0) {
			throw new CommonException("im消息模板号已经存在，不可重复", "base_is_exists", "im消息模板号");
		}
        imTemplate.setCreateDate(new Date());
        imTemplate.setModifyDate(new Date());
        this.imTemplateMapper.insertSelective(imTemplate);
    }

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.imTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    @Override
    public void modifyObj(ImTemplate imTemplate) {
        if (StringUtils.isBlank(imTemplate.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        if ((imTemplate.getTemplateNo() != null && imTemplate.getTemplateNo().length() > 255)
    		|| imTemplate.getTemplateTitle() != null && imTemplate.getTemplateTitle().length() > 255
            || imTemplate.getTemplateName() != null && imTemplate.getTemplateName().length() > 255) {
    		throw new CommonException("输入的参数长度超标", "database_length_error");
    	}
		if (!imTemplate.getBusinessType().matches("[\\w\\_]+")) {
			throw new CommonException("业务类型的格式错误");
		}
        imTemplate.setModifyDate(new Date());
        this.imTemplateMapper.updateByPrimaryKeySelective(imTemplate);
    }

    @Cacheable(value="imTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public ImTemplate queryObjById(String id) {
        return this.imTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="imTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public List<ImTemplate> queryAllObjByExample(ImTemplateExample example) {
        return this.imTemplateMapper.selectByExample(example);
    }

    @Cacheable(value="imTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ImTemplate> queryObjByPage(ImTemplateExample example) {
        PageView<ImTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.imTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="imTemplate", keyGenerator="redisKeyGenerator")
	@Override
	public ImTemplate queryImTemplateByBusinessType(String businessType) {
    	ImTemplateExample example = new ImTemplateExample();
    	example.createCriteria().andBusinessTypeEqualTo(businessType);

        List<ImTemplate> imTemplateList = this.imTemplateMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(imTemplateList)) {
			return null;
		}
        return imTemplateList.get(0);
	}

}