package com.els.base.msg.im.web.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.ResponseCode;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.im.util.MessageUtils;
import com.qqt.message.client.MessagePageVO;
import com.qqt.message.client.UserMessageExample;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api("消息管理-系统消息测试")
@Controller
@RequestMapping("imMessage")
public class ImMessageController {

	@ApiOperation(value="消息发送测试", httpMethod="POST")
	@RequestMapping("front/sendTestMessage")
	@ResponseBody
	public ResponseResult<String> sendTestMessage(String message, String sender, String receiver){
		String title = "测试标题" + DateFormatUtils.format(new Date(), "yyyyMMddhhmmss");
		String companyCode = "test";
		
		try {
			MessageUtils.pushSystemMessage(title, message, receiver, companyCode, MessageLevelEnum.HIGH);
			return ResponseResult.success();
		} catch (java.net.ConnectException e) {
			return ResponseResult.fail(ResponseCode.Fail, "连接消息服务器超时");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseResult.fail(ResponseCode.Fail);
	}
	
	@ApiOperation(value="查询系统消息", httpMethod="POST")
	@RequestMapping("service/querySysMessage")
	@ResponseBody
	public ResponseResult<MessagePageVO> querySysMessage(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize){
		
		UserMessageExample example = new UserMessageExample();
		example.andAccount(SpringSecurityUtils.getLoginUserId())
		       .andTypeEq(MessageUtils.TYPE_SYSTEM);
		
		Map<String,String> sorts = new HashMap<>();
		sorts.put("createTime", "DESC");
		
		MessagePageVO listMessage = null;
		try {
			listMessage = MessageUtils.listMessage(pageNo, pageSize, example, sorts);
		} catch (java.net.ConnectException e) {
			return ResponseResult.fail(ResponseCode.Fail, null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return ResponseResult.success(listMessage);
	}
	
	@ApiOperation(value="查询未读系统消息的数量", httpMethod="POST")
	@RequestMapping("service/querySysMessageUnreadCount")
	@ResponseBody
	public ResponseResult<Integer> querySysMessageUnreadCount(){
		
		UserMessageExample example = new UserMessageExample();
		example.andAccount(SpringSecurityUtils.getLoginUserId())
		.andTypeEq(MessageUtils.TYPE_SYSTEM)
		.andAccountUnread(SpringSecurityUtils.getLoginUserId());
		
		Map<String,String> sorts = new HashMap<>();
		sorts.put("createTime", "DESC");
		
		try {
			MessagePageVO result = MessageUtils.listMessage(1, 1, example, sorts);
			return ResponseResult.success(result.getTotal());
		} catch (java.net.ConnectException e) {
			return ResponseResult.fail(ResponseCode.Fail, 0);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseResult.success(0);
	}
	
	@ApiOperation(value="标记消息已读", httpMethod="POST")
	@RequestMapping("service/markAsRead")
	@ResponseBody
	public ResponseResult<String> markAsRead(String msgId){
		if (StringUtils.isBlank(msgId)) {
			throw new CommonException("请选择消息", "im_msg_id_is_null");
		}
		try {
			MessageUtils.markMsg2Read(msgId, SpringSecurityUtils.getLoginUserId());
			return ResponseResult.success();
		} catch (java.net.ConnectException e) {
			return ResponseResult.fail(ResponseCode.Fail, "连接消息服务器超时");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseResult.fail(ResponseCode.Fail);
	}
	
	@ApiOperation(value="标记消息已读", httpMethod="POST")
	@RequestMapping("service/markListAsRead")
	@ResponseBody
	public ResponseResult<String> markAsRead(@RequestBody List<String> msgIdList){
		if (CollectionUtils.isEmpty(msgIdList)) {
			throw new CommonException("请选择消息", "im_msg_id_is_null");
		}
		try {
			for(String msgId: msgIdList){
				MessageUtils.markMsg2Read(msgId, SpringSecurityUtils.getLoginUserId());
			}
			return ResponseResult.success();
		} catch (java.net.ConnectException e) {
			return ResponseResult.fail(ResponseCode.Fail, "连接消息服务器超时");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ResponseResult.fail(ResponseCode.Fail);
	}
	
}
