package com.els.base.msg.weixin;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;

import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;

public class ScanQrcodeHandler extends BaseMsgHandler {
	
	public ScanQrcodeHandler(WxMsgRule wxMsgRule) {
		super(wxMsgRule);
	}

	@Override
	public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
			WxSessionManager sessionManager) throws WxErrorException {
		if (!WxConsts.XML_MSG_EVENT.equals(wxMessage.getMsgType())) {
			return null;
		}
		
		if (!WxConsts.EVT_SCAN.equals(wxMessage.getEvent()) && !WxConsts.EVT_SUBSCRIBE.equals(wxMessage.getEvent())) {
			return null;
		}
		
		String key = wxMessage.getEventKey().replaceAll("qrscene_", "");
		if (!key.startsWith(WeixinMsgConstant.QRCODE_PREFIX_BIND_USER)) {
			return null;
		}
		
		String userId = key.replaceAll(WeixinMsgConstant.QRCODE_PREFIX_BIND_USER, "");
		
		WxMemberExample wxMemberExample = new WxMemberExample();
		wxMemberExample.createCriteria().andWxOpenidEqualTo(wxMessage.getFromUser());
		
		WxMemberService wxMemberService = SpringContextHolder.getBean("wxMemberService");
		List<WxMember> memberList = wxMemberService.queryAllObjByExample(wxMemberExample);
		
		
		String wxMemberId = null;
		if (CollectionUtils.isEmpty(memberList)) {
			WxMpUser wxMpUser = wxMpService.getUserService().userInfo(wxMessage.getFromUser(), null);
			wxMemberId = wxMemberService.createOrEditWxMember(wxMpUser, wxMessage.getEventKey(), wxMessage.getToUser()).getId();
			
		}else{
			wxMemberId = memberList.get(0).getId();
		}
		
		WxMember wxMember = new WxMember();
		wxMember.setId(wxMemberId);
		wxMember.setMemberId(userId);
		
		wxMemberService.modifyObj(wxMember);
		
		WxMpXmlOutTextMessage outMessage = new WxMpXmlOutTextMessage();
		outMessage.setCreateTime(new Date().getTime());
		outMessage.setFromUserName(wxMessage.getToUser());
		outMessage.setToUserName(wxMessage.getFromUser());
		
		outMessage.setContent("绑定成功。");
		return outMessage;
	}

}
