package com.els.base.msg.weixin;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.service.WxTemplateMessageService;
import com.els.base.wechat.msg.utils.WxMpTemplateMsgUtils;

public class WeixinMessageCommand implements IMessageCommand {
	
	private static final Logger logger = LoggerFactory.getLogger(WeixinMessageCommand.class);
	
	@Override
	public void sendMsg(IMessage<?> message) throws Exception {
		List<String> receiverIdList = message.getReceiverIdList();
		if (CollectionUtils.isEmpty(receiverIdList)) {
			return;
		}
		
		for(String receiverId : receiverIdList){
			sendMsg(receiverId, message);
		}
	}

	private void sendMsg(String receiverId, IMessage<?> message) {
		String businessType = message.getBusinessTypeCode();
		
		AccountConfig account = WxAccountConfigUtils.getDefaultAccountFromConfig();
		
		WxTemplateMessageService templateMessageService = SpringContextHolder.getOneBean(WxTemplateMessageService.class);
		WxTemplateMessage msgTemplate = templateMessageService.queryByAccountAndType(account.getId(), businessType);
		
		if (msgTemplate == null) {
			logger.warn("微信模板消息发送失败，因为该业务类型["+ businessType+"]还没有配置模板");
			return;
		}
		
		WxMemberExample wxMemberExample = new WxMemberExample();
		wxMemberExample.createCriteria().andMemberIdEqualTo(receiverId);
		
		WxMemberService wxMemberService = SpringContextHolder.getOneBean(WxMemberService.class);
		List<WxMember> list = wxMemberService.queryAllObjByExample(wxMemberExample);
		if (CollectionUtils.isEmpty(list)) {
			logger.warn("微信模板消息发送失败，因为该用户["+ receiverId+"]还没有关联微信公众号");
			return;
		}
		
		for(WxMember wxMember : list){
			WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, msgTemplate, message, wxMember.getWxOpenid());
		}

	}

}
