package com.els.base.notice.command;

import java.util.List;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

public class BatchCancelCommand implements IMsgCommand<String> {

	private List<String> noticeIdList;

	public BatchCancelCommand(List<String> noticeIdList) {
		this.noticeIdList = noticeIdList;
	}

	@Override
	public String execute(ImInvoker invoker) {
		Assert.isNotEmpty(noticeIdList, "撤销的公告不能为空");
		
		NoticeExample noticeExample = new NoticeExample();
		noticeExample.createCriteria().andIdIn(noticeIdList);
		
		Notice temp = new Notice();
		temp.setStatus(Constant.NO_INT);
		this.getNoticeService().modifyByExample(temp, noticeExample);
		
		return null;
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}
	

}
