package com.els.base.notice.command;

import java.util.Date;
import java.util.List;

import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;


public class BatchPublishCommand implements IMsgCommand<String> {

	private List<String> noticeIdList;
	private User user;

	public BatchPublishCommand(List<String> noticeIdList, User loginUser) {
		this.noticeIdList = noticeIdList;
		this.user = loginUser;
	}

	@Override
	public String execute(ImInvoker invoker) {
		Assert.isNotEmpty(noticeIdList, "发布的公告不能为空");
		Assert.isNotNull(user, "发布的人不能为空");
		
		NoticeExample noticeExample = new NoticeExample();
		noticeExample.createCriteria().andIdIn(noticeIdList);
		
		Notice temp = new Notice();
		temp.setPublishTime(new Date());
		temp.setPublishUserId(this.user.getId());
		temp.setPublishUserName(this.user.getNickName());
		temp.setStatus(Constant.YES_INT);
		this.getNoticeService().modifyByExample(temp, noticeExample);
		
		return null;
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}

}
