package com.els.base.notice.command;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

/**
 * 增加公告通知
 * @author hzy
 *
 */
public class CreateCommand implements IMsgCommand<String> {
	
	private static final String GERNERATOR_CODE = "NOTICE_NO_GENERATOR";

	private Notice notice;

	public CreateCommand(Notice notice) {
		this.notice = notice;
	}

	@Override
	public String execute(ImInvoker invoker) {
		//数据校验
		valid(this.notice);
		//初始化数据
		init(this.notice);
		//添加数据
		add(this.notice);
		
		return null;
	}

	private void add(Notice notice2) {
		this.getNoticeService().addObj(notice2);
		if (Constant.YES_INT.equals(notice2.getIsAllReceived())) {
			return;
		}
		
		String noticeId = notice2.getId();
		List<String> companyIdList = new ArrayList<>();
		for(NoticeReceiver company : notice2.getReceiverIdList()){
			companyIdList.add(company.getReceiverCompanyId());
		}
		this.getNoticeReceiverService().addAll(noticeId, companyIdList);
	}

	private NoticeReceiverService getNoticeReceiverService() {
		return SpringContextHolder.getOneBean(NoticeReceiverService.class);
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}

	private void init(Notice notice) {
		notice.setCreateTime(new Date());
		notice.setStatus(Constant.NO_INT);
		
		//默认发给所有人
		if (!Constant.YES_INT.equals(notice.getIsAllReceived())
				&& !Constant.NO_INT.equals(notice.getIsAllReceived())) {
			notice.setIsAllReceived(Constant.YES_INT);
		}
		
		GenerateCodeService generateCodeService = SpringContextHolder.getOneBean(GenerateCodeService.class);
		notice.setNoticeNo(generateCodeService.getNextCode(GERNERATOR_CODE));
	}

	private void valid(Notice notice) {
		Assert.isNotBlank(notice.getTitle(), "标题不能为空");
		Assert.isNotBlank(notice.getContent(), "内容不能为空");
		Assert.isNotBlank(notice.getType(), "类型不能为空");
		Assert.isNotBlank(notice.getCreateUserId(), "创建人Id不能为空");
		Assert.isNotBlank(notice.getCreateUserName(), "创建人不能为空");
		
		if (notice.getValidStartTime()!= null 
				&& notice.getValidEndTime() != null
				&& notice.getValidStartTime().getTime() > notice.getValidEndTime().getTime()) {
			
			throw new CommonException("开始生效时间，不能大于结束时间");
		}
		
		List<NoticeReceiver> blankIds = new ArrayList<>();
		if (Constant.NO_INT.equals(notice.getIsAllReceived())
				&& CollectionUtils.isNotEmpty(notice.getReceiverIdList())) {
			//清空空的id
			for(NoticeReceiver receiverId: notice.getReceiverIdList()){
				if (StringUtils.isBlank(receiverId.getReceiverCompanyId())) blankIds.add(receiverId);
			}
			
			notice.getReceiverIdList().removeAll(blankIds);
		}         
		
		if (Constant.NO_INT.equals(notice.getIsAllReceived())
				&& CollectionUtils.isEmpty(notice.getReceiverIdList())) {
			throw new CommonException("指定的接收方不能为空");
		}
		
	}

}
