package com.els.base.notice.command;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.els.base.core.utils.Constant;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;

public class PublishCommand implements IMsgCommand<String> {
	
	private Notice notice;

	public PublishCommand(Notice notice) {
		this.notice = notice;
	}

	@Override
	public String execute(ImInvoker invoker) {
		if (StringUtils.isBlank(this.notice.getId())) {
			
			//如果没有创建就先创建
			invoker.invoke(new CreateCommand(this.notice));
			
		}else {
			//保存最新修改
			invoker.invoke(new ModifyCommand(this.notice));
		}
		
		Notice temp = new Notice();
		temp.setId(this.notice.getId());
		temp.setPublishTime(new Date());
		temp.setPublishUserId(this.notice.getPublishUserId());
		temp.setPublishUserName(this.notice.getPublishUserName());
		temp.setStatus(Constant.YES_INT);
		
		this.getNoticeService().modifyObj(this.notice);
		
		return null;
	}

	private NoticeService getNoticeService() {
		return SpringContextHolder.getOneBean(NoticeService.class);
	}

}
