package com.els.base.msg.im.util;

import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.msg.MessageLevelEnum;
import com.qqt.message.client.MessageClient;
import com.qqt.message.client.MessageClientFactory;
import com.qqt.message.client.MessagePageVO;
import com.qqt.message.client.UserMessageExample;
/**
 * 推送消息工具类
 * @author Administrator
 *
 */
@Deprecated
public class MessageUtils {
	
	private static final Logger logger = LoggerFactory.getLogger(MessageUtils.class);
	private static final MessageUtils instance = new MessageUtils();
	public static final String TYPE_SYSTEM = "system";
	
	private MessageClient client = null;
	private MessageUtils(){
		try {
			client = MessageClientFactory.createPushMessageInstance();
			
		} catch (Exception e) {
			logger.error("消息工具类初始化失败", e);
		}
	}
	
	public MessageClient getClient() {
		return client;
	}


	/**
	  * 查询消息列表
	  * @param pageNumber   当前页
	  * @param pageSize     页大小
	  * @param example      查询条件
	  * @param sorts        排序【{"createTime":"ASC", "title":"DESC"}】
	  */
	public static MessagePageVO listMessage(int pageNumber,int pageSize,UserMessageExample example,Map<String,String> sorts) throws ConnectException {
		return instance.getClient().listMessage(pageNumber, pageSize, example, sorts);
	}

	/**
	 * 消息标为已读
	 * 
	 * @param msgId 消息ID
	 * @param account 账号
	 */
	public static void markMsg2Read(String msgId, String account) throws ConnectException {
		instance.getClient().markMsg2Read(msgId, account);
	}

	/**
	  * 推送消息
	  * @param title         消息标题(必填)
	  * @param content       消息内容(必填)
	  * @param type          消息类型【system代表系统消息，personal代表个人消息】(必填)
	  * @param accounts      接收消息的账号列表(必填)
	  * @param extras        消息的扩展
	  * @param companyCode   公司编码(必填)
	  * @param sender        发送者
	  */
	public static void pushMessage(String title, String content, String type, Set<String> accounts, Map<String, String> extras, String companyCode,  String sender) throws ConnectException {
		try {
			instance.getClient().pushMessage(title, content, type, accounts, extras, companyCode, sender);
		} catch (Exception e) {
			logger.error("发送im的消息失败", e);
		}
	}
	
	/**
	 * 推送消息
	 * @param title         消息标题(必填)
	 * @param content       消息内容(必填)
	 * @param accounts      接收消息的账号列表(必填)
	 * @param companyCode   公司编码(必填)
	 * @param level         消息级别
	 */
	public static void pushSystemMessage(String title, String content, Set<String> accounts, String companyCode, MessageLevelEnum level) throws ConnectException {
		Map<String, String> extras = new HashMap<>();
		extras.put("level", level.getLevel());
		
		pushMessage(title, content, TYPE_SYSTEM, accounts, extras, companyCode, null);
	}
	
	/**
	 * 推送消息
	 * @param title         消息标题(必填)
	 * @param content       消息内容(必填)
	 * @param receiver      接收消息的账号列表(必填)
	 * @param companyCode   公司编码(必填)
	 * @param sender        发送者
	 * @param level         消息级别
	 */
	public static void pushSystemMessage(String title, String content, String receiver, String companyCode, MessageLevelEnum level) throws ConnectException {
		if (StringUtils.isBlank(receiver)) {
			return;
		}
		
		Set<String> accounts = new HashSet<>();
		accounts.add(receiver);
		
		pushSystemMessage(title, content, accounts, companyCode, level);
	}
	
	/**
	 * 推送消息
	 * @param title         消息标题(必填)
	 * @param content       消息内容(必填)
	 * @param receiver      接收消息的账号列表(必填)
	 * @param companyCode   公司编码(必填)
	 * @param level         消息级别
	 * @param page          跳转到的页面
	 * @param sender        发送者
	 * @param extras        扩展
	 */
	public static void pushSystemMessage(String title, String content, Set<String> accounts, String companyCode, MessageLevelEnum level, MessagePageRedirectEnum page, String sender, Map<String, String> extras)  throws ConnectException {
		if (accounts == null || accounts.isEmpty()) {
			return;
		}
		
		if (extras == null) {
			extras = new HashMap<>();
		}
		extras.put("level", level.getLevel());
		extras.put("page", page.getPage());
		
		pushMessage(title, content, TYPE_SYSTEM, accounts, extras, companyCode, sender);
	}
	
}
