package com.els.base.notice.entity;

import java.io.Serializable;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.IgnoreDeserialzer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="关联的供应商")
public class NoticeReceiver implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("公告ID")
    private String noticeId;

    @ApiModelProperty("接收者ID")
    private String receiverCompanyId;
    
    
    @JsonDeserialize(using=IgnoreDeserialzer.class)
    @ApiModelProperty("供应商")
    private Company company;
    
    public Company getCompany() {
		return SpringContextHolder.getOneBean(CompanyService.class).queryObjById(this.getReceiverCompanyId());
	}

	public void setCompany(Company company) {
		this.company = company;
	}

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId == null ? null : noticeId.trim();
    }

    public String getReceiverCompanyId() {
        return receiverCompanyId;
    }

    public void setReceiverCompanyId(String receiverCompanyId) {
        this.receiverCompanyId = receiverCompanyId == null ? null : receiverCompanyId.trim();
    }
    
    
}