/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.command;

import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.notice.command.IMsgCommand;
import com.els.base.notice.command.ImInvoker;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;

public class BatchPublishCommand
implements IMsgCommand<String> {
    private List<String> noticeIdList;
    private User user;

    public BatchPublishCommand(List<String> noticeIdList, User loginUser) {
        this.noticeIdList = noticeIdList;
        this.user = loginUser;
    }

    @Override
    public String execute(ImInvoker invoker) {
        Assert.isNotEmpty(this.noticeIdList, (String)"\u53d1\u5e03\u7684\u516c\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.user, (String)"\u53d1\u5e03\u7684\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        NoticeExample noticeExample = new NoticeExample();
        noticeExample.createCriteria().andIdIn((List)this.noticeIdList);
        Notice temp = new Notice();
        temp.setPublishTime(new Date());
        temp.setPublishUserId(this.user.getId());
        temp.setPublishUserName(this.user.getNickName());
        temp.setStatus(Constant.YES_INT);
        this.getNoticeService().modifyByExample(temp, noticeExample);
        return null;
    }

    private NoticeService getNoticeService() {
        return (NoticeService)SpringContextHolder.getOneBean(NoticeService.class);
    }
}

