/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.msg.im.dao.ImTemplateMapper;
import com.els.base.msg.im.entity.ImTemplate;
import com.els.base.msg.im.entity.ImTemplateExample;
import com.els.base.msg.im.service.ImTemplateService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultImTemplateService")
public class ImTemplateServiceImpl
implements ImTemplateService {
    @Resource
    protected ImTemplateMapper imTemplateMapper;

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    public void addObj(ImTemplate imTemplate) {
        if (imTemplate.getTemplateNo() != null && imTemplate.getTemplateNo().length() > 255 || imTemplate.getTemplateTitle() != null && imTemplate.getTemplateTitle().length() > 255 || imTemplate.getTemplateName() != null && imTemplate.getTemplateName().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (!imTemplate.getBusinessType().matches("[\\w\\_]+")) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
        }
        ImTemplateExample example = new ImTemplateExample();
        example.createCriteria().andProjectIdEqualTo(imTemplate.getProjectId()).andCompanyIdEqualTo(imTemplate.getCompanyId()).andBusinessTypeEqualTo(imTemplate.getBusinessType());
        if (this.imTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", "base_is_exists", new Object[]{"\u4e1a\u52a1\u7c7b\u578b"});
        }
        example.clear();
        example.createCriteria().andProjectIdEqualTo(imTemplate.getProjectId()).andCompanyIdEqualTo(imTemplate.getCompanyId()).andTemplateNoEqualTo(imTemplate.getTemplateNo());
        if (this.imTemplateMapper.countByExample(example) > 0) {
            throw new CommonException("im\u6d88\u606f\u6a21\u677f\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", "base_is_exists", new Object[]{"im\u6d88\u606f\u6a21\u677f\u53f7"});
        }
        imTemplate.setCreateDate(new Date());
        imTemplate.setModifyDate(new Date());
        this.imTemplateMapper.insertSelective(imTemplate);
    }

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.imTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"imTemplate"}, allEntries=true)
    public void modifyObj(ImTemplate imTemplate) {
        if (StringUtils.isBlank((String)imTemplate.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (imTemplate.getTemplateNo() != null && imTemplate.getTemplateNo().length() > 255 || imTemplate.getTemplateTitle() != null && imTemplate.getTemplateTitle().length() > 255 || imTemplate.getTemplateName() != null && imTemplate.getTemplateName().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (!imTemplate.getBusinessType().matches("[\\w\\_]+")) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
        }
        imTemplate.setModifyDate(new Date());
        this.imTemplateMapper.updateByPrimaryKeySelective(imTemplate);
    }

    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public ImTemplate queryObjById(String id) {
        return this.imTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public List<ImTemplate> queryAllObjByExample(ImTemplateExample example) {
        return this.imTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<ImTemplate> queryObjByPage(ImTemplateExample example) {
        PageView<ImTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.imTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public ImTemplate queryImTemplateByBusinessType(String businessType) {
        ImTemplateExample example = new ImTemplateExample();
        example.createCriteria().andBusinessTypeEqualTo(businessType);
        List<ImTemplate> imTemplateList = this.imTemplateMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(imTemplateList)) {
            return null;
        }
        return imTemplateList.get(0);
    }

    @Transactional
    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public void addAll(List<ImTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.imTemplateMapper.insertSelective((ImTemplate)item);
            }
        });
    }

    @Cacheable(value={"imTemplate"}, keyGenerator="redisKeyGenerator")
    public void deleteByExample(ImTemplateExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.imTemplateMapper.deleteByExample(arg0);
    }
}

