/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.dao.MailAccountMapper;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailAccountExample;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.utils.SmtpSendUtils;
import com.els.base.utils.encryption.DESUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMailAccountService")
public class MailAccountServiceImpl
implements MailAccountService {
    @Resource
    protected MailAccountMapper mailAccountMapper;
    @Resource
    protected UserService userService;

    @CacheEvict(value={"mailAccount"}, allEntries=true)
    public void addObj(MailAccount mailAccount) {
        Assert.isNotBlank((String)mailAccount.getPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getMailAddress(), (String)"\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getUserLoginName(), (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getCompanyId(), (String)"\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getStmpServerHost(), (String)"STMP\u670d\u52a1\u5668\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mailAccount.getStmpServerPort(), (String)"STMP\u670d\u52a1\u5668\u7aef\u53e3 \u4e0d\u80fd\u4e3a\u7a7a");
        if (!Constant.YES_INT.equals(mailAccount.getStmpServerIsSsl()) && !Constant.NO_INT.equals(mailAccount.getStmpServerIsSsl())) {
            mailAccount.setStmpServerIsSsl(Constant.NO_INT);
        }
        MailAccountExample mailAccountExample = new MailAccountExample();
        MailAccountExample.Criteria cri = mailAccountExample.createCriteria();
        cri.andCompanyIdEqualTo(mailAccount.getCompanyId()).andMailAddressEqualTo(mailAccount.getMailAddress());
        if (this.mailAccountMapper.countByExample(mailAccountExample) > 0) {
            throw new CommonException("\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u8be5\u90ae\u7bb1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        mailAccountExample.clear();
        cri = mailAccountExample.createCriteria();
        cri.andUserLoginNameEqualTo(mailAccount.getUserLoginName());
        if (this.mailAccountMapper.countByExample(mailAccountExample) > 0) {
            throw new CommonException("\u8be5\u5e10\u53f7\u5df2\u7ecf\u8bbe\u7f6e\u90ae\u7bb1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        User user = this.userService.findByUserLoginName(mailAccount.getUserLoginName());
        if (user == null) {
            throw new CommonException("\u8be5\u5e10\u53f7\u4e0d\u5b58\u5728");
        }
        mailAccount.setUserId(user.getId());
        mailAccountExample.clear();
        cri = mailAccountExample.createCriteria();
        cri.andCompanyIdEqualTo(mailAccount.getCompanyId());
        if (this.mailAccountMapper.countByExample(mailAccountExample) == 0) {
            mailAccount.setIsDefault(Constant.YES_INT);
        } else {
            mailAccount.setIsDefault(Constant.NO_INT);
        }
        mailAccount.setCreateTime(new Date());
        try {
            String password = DESUtils.encrypt((String)mailAccount.getPassword(), (String)"tissonco");
            mailAccount.setPassword(password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            SmtpSendUtils.testConnection(mailAccount);
        }
        catch (Exception e) {
            throw new CommonException("\u5e10\u53f7\u670d\u52a1\u5668\u8fde\u63a5\u9a8c\u8bc1\u5931\u8d25");
        }
        this.mailAccountMapper.insertSelective(mailAccount);
    }

    @Transactional
    @CacheEvict(value={"mailAccount"}, allEntries=true)
    public void deleteObjById(String id) {
        MailAccount mailAccount = this.mailAccountMapper.selectByPrimaryKey(id);
        this.mailAccountMapper.deleteByPrimaryKey(id);
        MailAccountExample example = new MailAccountExample();
        example.createCriteria().andCompanyIdEqualTo(mailAccount.getCompanyId());
        if (this.mailAccountMapper.countByExample(example) == 0) {
            throw new CommonException("\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u90ae\u7bb1\u5e10\u53f7\u6765\u6536\u53d6\u90ae\u4ef6\u6d88\u606f");
        }
        if (this.mailAccountMapper.countByExample(example) > 1) {
            return;
        }
        MailAccount temp = new MailAccount();
        temp.setIsDefault(Constant.YES_INT);
        this.mailAccountMapper.updateByExampleSelective(temp, example);
    }

    @CacheEvict(value={"mailAccount"}, allEntries=true)
    public void modifyObj(MailAccount mailAccount) {
        MailAccount mail;
        Assert.isNotBlank((String)mailAccount.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        Assert.isNotBlank((String)mailAccount.getPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getMailAddress(), (String)"\u90ae\u7bb1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getUserLoginName(), (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)mailAccount.getStmpServerHost(), (String)"STMP\u670d\u52a1\u5668\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)mailAccount.getStmpServerPort(), (String)"STMP\u670d\u52a1\u5668\u7aef\u53e3 \u4e0d\u80fd\u4e3a\u7a7a");
        mailAccount.setIsDefault(null);
        MailAccountExample mailAccountExample = new MailAccountExample();
        MailAccountExample.Criteria cri = mailAccountExample.createCriteria();
        cri.andCompanyIdEqualTo(mailAccount.getCompanyId()).andMailAddressEqualTo(mailAccount.getMailAddress()).andIdNotEqualTo(mailAccount.getId());
        if (this.mailAccountMapper.countByExample(mailAccountExample) > 0) {
            throw new CommonException("\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u8be5\u90ae\u7bb1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        mailAccountExample.clear();
        cri = mailAccountExample.createCriteria();
        cri.andUserLoginNameEqualTo(mailAccount.getUserLoginName()).andIdNotEqualTo(mailAccount.getId());
        if (this.mailAccountMapper.countByExample(mailAccountExample) > 0) {
            throw new CommonException("\u8be5\u5e10\u53f7\u5df2\u7ecf\u8bbe\u7f6e\u90ae\u7bb1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        User user = this.userService.findByUserLoginName(mailAccount.getUserLoginName());
        if (user == null) {
            throw new CommonException("\u8be5\u5e10\u53f7\u4e0d\u5b58\u5728");
        }
        mailAccount.setUserId(user.getId());
        if (StringUtils.isNotBlank((String)mailAccount.getUserId())) {
            mailAccountExample.clear();
            cri = mailAccountExample.createCriteria();
            cri.andUserIdEqualTo(mailAccount.getUserId()).andIdNotEqualTo(mailAccount.getId());
            if (this.mailAccountMapper.countByExample(mailAccountExample) > 0) {
                throw new CommonException("\u8be5\u5e10\u53f7\u5df2\u7ecf\u8bbe\u7f6e\u90ae\u7bb1\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
            }
        }
        if (StringUtils.isNotBlank((String)mailAccount.getPassword()) && !(mail = this.mailAccountMapper.selectByPrimaryKey(mailAccount.getId())).getPassword().equals(mailAccount.getPassword())) {
            try {
                String enPassword = DESUtils.encrypt((String)mailAccount.getPassword(), (String)"tissonco");
                mailAccount.setPassword(enPassword);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            SmtpSendUtils.testConnection(mailAccount);
        }
        catch (Exception e) {
            throw new CommonException("\u5e10\u53f7\u670d\u52a1\u5668\u8fde\u63a5\u9a8c\u8bc1\u5931\u8d25");
        }
        this.mailAccountMapper.updateByPrimaryKeySelective(mailAccount);
    }

    @Cacheable(value={"mailAccount"}, keyGenerator="redisKeyGenerator")
    public MailAccount queryObjById(String id) {
        return this.mailAccountMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mailAccount"}, keyGenerator="redisKeyGenerator")
    public List<MailAccount> queryAllObjByExample(MailAccountExample example) {
        return this.mailAccountMapper.selectByExample(example);
    }

    @Cacheable(value={"mailAccount"}, keyGenerator="redisKeyGenerator")
    public PageView<MailAccount> queryObjByPage(MailAccountExample example) {
        PageView<MailAccount> pageView = example.getPageView();
        pageView.setQueryResult(this.mailAccountMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"mailAccount"}, keyGenerator="redisKeyGenerator")
    public MailAccount queryByUserId(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MailAccountExample mailAccountExample = new MailAccountExample();
        MailAccountExample.Criteria cri = mailAccountExample.createCriteria();
        cri.andUserIdEqualTo(userId);
        List<MailAccount> accountList = this.mailAccountMapper.selectByExample(mailAccountExample);
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }
        return accountList.get(0);
    }

    @Override
    @Cacheable(value={"mailAccount"}, keyGenerator="redisKeyGenerator")
    public MailAccount queryDefaultMailAccoutByCompanyId(String companyId) {
        if (StringUtils.isBlank((String)companyId)) {
            throw new CommonException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MailAccountExample mailAccountExample = new MailAccountExample();
        MailAccountExample.Criteria cri = mailAccountExample.createCriteria();
        cri.andCompanyIdEqualTo(companyId).andIsDefaultEqualTo(Constant.YES_INT);
        mailAccountExample.setOrderByClause("CREATE_TIME ASC");
        List<MailAccount> list = this.mailAccountMapper.selectByExample(mailAccountExample);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        mailAccountExample.clear();
        cri = mailAccountExample.createCriteria();
        cri.andCompanyIdEqualTo(companyId);
        mailAccountExample.setOrderByClause("CREATE_TIME ASC");
        list = this.mailAccountMapper.selectByExample(mailAccountExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"mailAccount"}, allEntries=true)
    @Transactional
    public void setMailAccountAsDefault(String companyId, String mailAccountId) {
        if (StringUtils.isBlank((String)companyId) || StringUtils.isBlank((String)mailAccountId)) {
            throw new CommonException("\u4f01\u4e1aid\u6216\u8005\u90ae\u7bb1\u5e10\u53f7id\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MailAccount mailAccount = this.mailAccountMapper.selectByPrimaryKey(mailAccountId);
        if (mailAccount == null) {
            throw new CommonException("\u8be5\u90ae\u7bb1\u4e0d\u5b58\u5728");
        }
        if (!companyId.equals(mailAccount.getCompanyId())) {
            throw new CommonException("\u8be5\u90ae\u7bb1\u4e0d\u5c5e\u4e8e\u8be5\u516c\u53f8\u7684\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9ed8\u8ba4");
        }
        MailAccountExample example = new MailAccountExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        MailAccount temp = new MailAccount();
        temp.setIsDefault(Constant.NO_INT);
        this.mailAccountMapper.updateByExampleSelective(temp, example);
        temp.setIsDefault(Constant.YES_INT);
        temp.setId(mailAccountId);
        this.mailAccountMapper.updateByPrimaryKeySelective(temp);
    }

    @Transactional
    @CacheEvict(value={"mailAccount"}, allEntries=true)
    public void addAll(List<MailAccount> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.mailAccountMapper.insertSelective((MailAccount)item);
            }
        });
    }

    @CacheEvict(value={"mailAccount"}, allEntries=true)
    public void deleteByExample(MailAccountExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mailAccountMapper.deleteByExample(arg0);
    }
}

