/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.notice.dao.NoticeMapper;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultNoticeService")
public class NoticeServiceImpl
implements NoticeService {
    @Resource
    protected NoticeMapper noticeMapper;
    @Resource
    protected NoticeReceiverService noticeReceiverService;

    @CacheEvict(value={"notice"}, allEntries=true)
    public void addObj(Notice t) {
        this.noticeMapper.insertSelective(t);
    }

    @CacheEvict(value={"notice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.noticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"notice"}, allEntries=true)
    public void modifyObj(Notice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.noticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"notice"}, keyGenerator="redisKeyGenerator")
    public Notice queryObjById(String id) {
        return this.noticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"notice"}, keyGenerator="redisKeyGenerator")
    public List<Notice> queryAllObjByExample(NoticeExample example) {
        List<Notice> noticeList = this.noticeMapper.selectByExample(example);
        for (Notice notice : noticeList) {
            notice.setReceiverIdList(this.noticeReceiverService.queryObjByNoticeId(notice.getId()));
        }
        return noticeList;
    }

    @Cacheable(value={"notice"}, keyGenerator="redisKeyGenerator")
    public PageView<Notice> queryObjByPage(NoticeExample example) {
        PageView<Notice> pageView = example.getPageView();
        List<Notice> noticeList = this.noticeMapper.selectByExampleByPage(example);
        for (Notice notice : noticeList) {
            notice.setReceiverIdList(this.noticeReceiverService.queryObjByNoticeId(notice.getId()));
        }
        pageView.setQueryResult(noticeList);
        return pageView;
    }

    @Override
    @CacheEvict(value={"notice"}, allEntries=true)
    public void modifyByExample(Notice notice, NoticeExample noticeExample) {
        notice.setId(null);
        this.noticeMapper.updateByExampleSelective(notice, noticeExample);
    }

    @Transactional
    @CacheEvict(value={"notice"}, allEntries=true)
    public void addAll(List<Notice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.noticeMapper.insertSelective((Notice)item);
            }
        });
    }

    @CacheEvict(value={"notice"}, allEntries=true)
    public void deleteByExample(NoticeExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.noticeMapper.deleteByExample(arg0);
    }
}

