/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class RecallCommand
extends AbstractInquiryCommand<String> {
    private List<String> ids;

    public RecallCommand(List<String> ids) {
        this.ids = ids;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.ids, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID\uff0c\u67e5\u8be2\u8be2\u4ef7\u5355\u6570\u636e");
        List<PurOrder> purOrderList = this.queryPurOrdersByIds(this.ids);
        this.valid(purOrderList);
        this.deleteAllSupOrders(this.ids);
        this.deleteAllItems(purOrderList);
        this.deleteAllMoulds(purOrderList);
        this.deleteAllBusinessCondtion(this.ids);
        invoker.getPurOrderService().transformToUnPublish(this.ids);
        return null;
    }

    private void deleteAllBusinessCondtion(List<String> ids) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andPurOrderIdIn((List)ids);
        this.invoker.getInquiryBusiConditionService().deleteByExample(example);
    }

    private void deleteAllMoulds(List<PurOrder> purOrderList) {
        this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID,\u5220\u9664\u6240\u6709\u6a21\u5177\u6e05\u5355,\u4e0e\u6a21\u5177\u6e05\u5355\u660e\u7ec6");
        purOrderList.stream().forEach(purOrder -> {
            TemplateConf templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
            if (!Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
                return;
            }
            List<IMould> mouldList = templateConf.getMouldService().queryByPurOrderId(purOrder.getId());
            if (CollectionUtils.isEmpty(mouldList)) {
                return;
            }
            this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID[{}],\u5220\u9664\u6240\u6709\u6a21\u5177\u6e05\u5355", (Object)purOrder.getId());
            templateConf.getMouldService().deleteByPurOrder(purOrder.getId());
            this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID,\u5220\u9664\u6240\u6709\u6a21\u5177\u6e05\u5355\u6210\u672c\u6e05\u5355");
            List<String> mouldIdList = mouldList.stream().map(IMould::getId).collect(Collectors.toList());
            if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable()) && CollectionUtils.isNotEmpty(mouldIdList)) {
                templateConf.getTplMouLdDetail().getMouldDetailService().deleteByMouldIdList(mouldIdList);
            }
            this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID[{}],\u63d2\u5165\u672a\u53d1\u9001\u7684\u6a21\u5177\u6e05\u5355", (Object)purOrder.getId());
            List<InquirySupplier> supplierList = this.invoker.getInquirySupplierService().queryByPurOrderId(purOrder.getId());
            InquirySupplier supplier = supplierList.get(0);
            List<IMould> recallMouldList = mouldList.stream().filter(mould -> supplier.getSupCompanySrmCode().equals(mould.getSupCompanySrmCode())).collect(Collectors.toList());
            recallMouldList.forEach(newMould -> {
                newMould.setSupCompanyName(null);
                newMould.setSupCompanySrmCode(null);
                newMould.setSupCompanySapCode(null);
            });
            templateConf.getMouldService().addAll(recallMouldList);
        });
    }

    private void deleteAllItems(List<PurOrder> purOrderList) {
        this.logger.info("\u6839\u636e\u6240\u6709\u8be2\u4ef7\u5355\u884cid,\u5220\u9664\u6240\u6709\u8be2\u4ef7\u5355\u884c");
        List orderItemIdList = purOrderList.stream().flatMap(purOrder -> {
            TemplateConf templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
            List<IOrderItem> tempList = templateConf.getOrderItemService().queryByPurOrderId(purOrder.getId());
            List<String> itemIdList = tempList.stream().map(IOrderItem::getId).collect(Collectors.toList());
            if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable()) && CollectionUtils.isNotEmpty(itemIdList)) {
                templateConf.getTplOrderItemDetail().getOrderItemDetailService().deleteByOrderItemIds(itemIdList);
            }
            templateConf.getOrderItemService().deleteByPurOrderId(purOrder.getId());
            return itemIdList.stream();
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            return;
        }
        this.logger.info("\u6839\u636e\u6240\u6709\u8be2\u4ef7\u5355\u884c,\u5220\u9664\u9636\u68af\u62a5\u4ef7");
        InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
        example.createCriteria().andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_ITEM.getCode()).andItemIdIn(orderItemIdList);
        this.invoker.getInquiryQuoteLadderService().deleteByExample(example);
    }

    private void deleteAllSupOrders(List<String> idList) {
        this.logger.info("\u6839\u636e\u8be2\u4ef7\u5355ID,\u5220\u9664\u6240\u6709\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355,ids[{}]", this.ids);
        InquirySupOrderExample example = new InquirySupOrderExample();
        InquirySupOrderExample.Criteria criteria = example.createCriteria();
        criteria.andPurOrderIdIn((List)idList);
        this.invoker.getInquirySupOrderService().deleteByExample(example);
    }

    private void valid(List<PurOrder> purOrders) {
        Assert.isNotEmpty(purOrders, "\u8be2\u4ef7\u5355\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        for (PurOrder purOrder : purOrders) {
            if (InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u64a4\u56de\u3002\u8be2\u4ef7\u5355[%s]", purOrder.getOrderNo()));
        }
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdIn(purOrders.stream().map(PurOrder::getId).collect(Collectors.toList())).andQuoteStatusNotEqualTo(InquiryQuoteStatus.UNQUOTED.getCode());
        List inquirySupOrders = this.invoker.getInquirySupOrderService().queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(inquirySupOrders)) {
            throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5df2\u7ecf\u6709\u4f9b\u5e94\u5546\u8fdb\u884c\u62a5\u4ef7\uff0c\u65e0\u6cd5\u64a4\u56de\u3002\u8be2\u4ef7\u5355[%s]", ((InquirySupOrder)inquirySupOrders.get(0)).getOrderNo()));
        }
    }

    private List<PurOrder> queryPurOrdersByIds(List<String> idList) {
        PurOrderExample example = new PurOrderExample();
        PurOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        return this.invoker.getPurOrderService().queryAllObjByExample(example);
    }
}

